/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.alarm.Alarm;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSeverity;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlarmXMLImpl
extends Alarm {
    public static final String cvs_id = "$Id: AlarmXMLImpl.java,v 1.2 2004/10/13 18:09:45 jkremer Exp $";

    public static AlarmXMLImpl parseAlarm(String doc) {
        return AlarmXMLImpl.parseNode(XMLUtil.getNode(doc));
    }

    private static AlarmXMLImpl parseNode(Node node) {
        NodeList children;
        AlarmXMLImpl alarm = new AlarmXMLImpl();
        if (node.getNodeType() == 1 && "ALARM".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                AlarmXMLImpl.parseNode(cnode, alarm);
            }
        }
        return alarm;
    }

    private static void parseNode(Node node, AlarmXMLImpl a) {
        if (node.getNodeType() == 1) {
            String ack;
            if ("CODE".equals(node.getNodeName())) {
                a.gridCode = XMLUtil.getCdata(node);
            }
            if ("ACK".equals(node.getNodeName()) && "Y".equals(ack = XMLUtil.getCdata(node))) {
                a.state = 1;
            }
            if ("ACK_LOGIN".equals(node.getNodeName())) {
                a.ack_login = XMLUtil.getCdata(node);
            }
            if ("NOTE".equals(node.getNodeName())) {
                a.note = XMLUtil.getCdata(node);
            }
            if ("SEVERITY".equals(node.getNodeName())) {
                int severity = Integer.parseInt(XMLUtil.getCdata(node).trim());
                a.severity = AlarmSeverity.mapStoradeSeverity(severity);
            }
            if ("COMPONENT".equals(node.getNodeName())) {
                a.component = XMLUtil.getCdata(node);
            }
            if ("DESC".equals(node.getNodeName())) {
                a.description = XMLUtil.getCdata(node);
            }
            if ("INFO".equals(node.getNodeName())) {
                a.info = XMLUtil.getCdata(node);
            }
            if ("PROBABLE_CAUSE".equals(node.getNodeName())) {
                a.probableCause = XMLUtil.getCdata(node);
            }
            if ("RECOMMENDED_ACTION".equals(node.getNodeName())) {
                a.recommendedAction = XMLUtil.getCdata(node);
            }
        }
    }
}

