/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.AlarmSummaryXML;
import com.sun.netstorage.fm.storade.client.http.AlarmXMLImpl;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.alarm.Alarm;
import com.sun.netstorage.fm.storade.service.alarm.AlarmCounts;
import com.sun.netstorage.fm.storade.service.alarm.AlarmService;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSummary;
import com.sun.netstorage.fm.storade.util.StoradeDate;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlarmQueryImpl
extends AbstractService
implements AlarmService {
    public static final String cvs_id = "$Id: AlarmQueryImpl.java,v 1.10 2005/03/24 16:12:12 jkremer Exp $";

    public AlarmQueryImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public AlarmCounts getAlarmCounts() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::summary");
        cmd.fastcgi();
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        AlarmCounts ac = AlarmQueryImpl.parseAlarmCounts(resp.getData());
        return ac;
    }

    public AlarmCounts getAlarmCounts(String deviceFilter) throws StoradeException {
        AlarmSummary[] as = this.getAlarms(null, null, new String[]{deviceFilter});
        int[] counts = new int[4];
        for (int i = 0; i < as.length; ++i) {
            this.addCount(as[i].getSeverity(), counts);
        }
        return new AlarmCounts(counts[0], counts[1], counts[2], counts[3]);
    }

    public AlarmCounts getAlarmCounts(int[] state, String[] device) throws StoradeException {
        AlarmSummary[] as = this.getAlarms(null, state, device);
        int[] counts = new int[4];
        for (int i = 0; i < as.length; ++i) {
            this.addCount(as[i].getSeverity(), counts);
        }
        return new AlarmCounts(counts[0], counts[1], counts[2], counts[3]);
    }

    private boolean devMatch(String type, String key, String filter) {
        if (filter == null) {
            return true;
        }
        if (filter.indexOf(":") > 0) {
            return filter.equals(type + ":" + key);
        }
        return filter.equals(type);
    }

    private void addCount(int severity, int[] counts) {
        switch (severity) {
            case 4: {
                counts[0] = counts[0] + 1;
                break;
            }
            case 3: {
                counts[1] = counts[1] + 1;
                break;
            }
            case 2: {
                counts[2] = counts[2] + 1;
                break;
            }
            case 1: {
                counts[3] = counts[3] + 1;
            }
        }
    }

    public AlarmSummary[] getAlarms() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Control::GetAlarms");
        cmd.setProperty("format", "xml");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "ALARMS");
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmSummaryXML.parseXML(resp.getData());
    }

    public AlarmSummary[] getAlarms(int[] severity, int[] state, String[] device) throws StoradeException {
        AlarmSummary[] as = this.getAlarms();
        LinkedList<AlarmSummary> list = new LinkedList<AlarmSummary>();
        for (int i = 0; i < as.length; ++i) {
            int aState = as[i].getState();
            String type = as[i].getDeviceType();
            String key = as[i].getDeviceKey();
            boolean stateFilter = true;
            boolean devFilter = true;
            if (state != null) {
                stateFilter = false;
                int s = as[i].getState();
                for (int j = 0; j < state.length; ++j) {
                    if (s != state[j]) continue;
                    stateFilter = true;
                    break;
                }
            }
            if (device != null) {
                devFilter = false;
                for (int j = 0; j < device.length; ++j) {
                    if (!this.devMatch(type, key, device[j])) continue;
                    devFilter = true;
                    break;
                }
            }
            if (!devFilter || !stateFilter) continue;
            list.add(as[i]);
        }
        AlarmSummary[] retval = new AlarmSummary[list.size()];
        list.toArray(retval);
        return retval;
    }

    public Alarm getAlarmDetail(String alarmSummaryId) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::GetAlarm");
        cmd.setProperty("format", "xml");
        cmd.setProperty("event", alarmSummaryId);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmXMLImpl.parseAlarm(resp.getData());
    }

    public Alarm getAlarmDetail(String alarmSummaryId, Locale locale) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::GetAlarm");
        cmd.setProperty("format", "xml");
        cmd.setProperty("event", alarmSummaryId);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        cmd.setProperty("locale", locale.getCountry());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmXMLImpl.parseAlarm(resp.getData());
    }

    private static AlarmCounts parseAlarmCounts(String report) {
        int[] a = new int[4];
        Date date = new Date();
        AlarmQueryImpl.parseAlarmCountsNode(XMLUtil.getNode(report), a, date);
        return new AlarmCounts(a[0], a[1], a[2], a[3], date);
    }

    private static void parseAlarmCountsNode(Node node, int[] a, Date d) {
        if (node.getNodeType() == 1) {
            if ("alarmSummary".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node cnode = children.item(j);
                        AlarmQueryImpl.parseAlarmCountsNode(cnode, a, d);
                    }
                }
            } else if ("date".equals(node.getNodeName())) {
                StoradeDate sd = new StoradeDate(XMLUtil.getCdata(node));
                d = sd.getDate();
            } else if ("down".equals(node.getNodeName())) {
                a[0] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("critical".equals(node.getNodeName())) {
                a[1] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("major".equals(node.getNodeName())) {
                a[2] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("minor".equals(node.getNodeName())) {
                a[3] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            }
        }
    }

    public void setNote(String alarmSummaryId, String note) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::setNote");
        String[] keyTopic = this.keyTopic(alarmSummaryId);
        cmd.setProperty("key", keyTopic[0]);
        cmd.setProperty("topic", keyTopic[1]);
        cmd.setProperty("note", note);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }

    private String[] keyTopic(String alarmSummaryId) throws StoradeException {
        Pattern p = Pattern.compile("(.*)\\:(.*)");
        Matcher m = p.matcher(alarmSummaryId);
        if (!m.matches()) {
            throw new StoradeException("id.does.not.exist", new Object[]{alarmSummaryId});
        }
        return new String[]{m.group(1), m.group(2)};
    }

    public void acknowledge(String alarmSummaryId, String user) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::ackAlarm");
        String[] keyTopic = this.keyTopic(alarmSummaryId);
        cmd.setProperty("key", keyTopic[0]);
        cmd.setProperty("topic", keyTopic[1]);
        cmd.setProperty("login", user);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }

    public void reopen(String alarmSummaryId, String user) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::nackAlarm");
        String[] keyTopic = this.keyTopic(alarmSummaryId);
        cmd.setProperty("key", keyTopic[0]);
        cmd.setProperty("topic", keyTopic[1]);
        cmd.setProperty("login", user);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }

    public void deleteAlarm(String alarmSummaryId) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::delAlarm");
        String[] keyTopic = this.keyTopic(alarmSummaryId);
        cmd.setProperty("key", keyTopic[0]);
        cmd.setProperty("topic", keyTopic[1]);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }
}

