/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import org.w3c.dom.Node;

public class AgentError {
    public static final int OK = 0;
    public static final int HTTP_ERROR = -1;
    public static final int PARSE_ERROR = -2;
    public static final int AUTHENTICATION_ERROR = -3;
    private int errno;
    private String message;
    private StoradeException exception;
    public static final String cvs_id = "$Id: AgentError.java,v 1.7 2004/10/13 18:09:45 jkremer Exp $";

    public StoradeException toException() {
        if (this.exception != null) {
            return this.exception;
        }
        if (this.errno == -1) {
            return new StoradeException("communication.error");
        }
        if (this.errno == -3) {
            return new StoradeException("authentication.error");
        }
        return new StoradeException("sa.cmd.error", new Object[]{new Integer(this.errno), this.message});
    }

    public AgentError(HTTPResponse resp) {
        this(resp, null);
    }

    public AgentError(HTTPResponse resp, String docName) {
        if (resp.getResponseCode() != 200) {
            this.errno = -1;
            this.message = resp.getData();
            if (this.message == null) {
                this.message = "communication.error";
            }
            this.exception = new StoradeException("communication.error", resp.getError());
        } else {
            this.parseDoc(resp.getData(), docName);
        }
    }

    public AgentError(String xmlDoc) {
        this.parseDoc(xmlDoc, null);
    }

    private void parseDoc(String xmlDoc, String docName) {
        int index;
        if (xmlDoc == null) {
            this.errno = -1;
            this.message = "invalid.document";
            this.exception = new StoradeException("invalid.document", new Object[]{docName, xmlDoc});
            return;
        }
        if (docName != null && !xmlDoc.startsWith("<" + docName)) {
            int index2 = xmlDoc.indexOf("<ERROR");
            if (index2 >= 0) {
                this.parseNode(XMLUtil.getNode(xmlDoc));
                return;
            }
            this.errno = -1;
            this.message = "invalid.document";
            this.exception = new StoradeException("invalid.document", new Object[]{docName, xmlDoc});
            return;
        }
        if (xmlDoc.startsWith("#ERROR\t")) {
            String emsg = xmlDoc.substring(7);
            int mindex = emsg.indexOf("\t");
            try {
                this.errno = Integer.parseInt(emsg.substring(0, mindex));
                this.message = emsg.substring(mindex + 1);
            }
            catch (Exception e) {
                this.errno = -2;
                this.message = e.getMessage();
            }
        }
        if (xmlDoc.startsWith("<head>")) {
            if (xmlDoc.indexOf("GUI::Login::login") > 0) {
                this.errno = -3;
                this.message = "authentication.error";
                return;
            }
            if (xmlDoc.indexOf("name=ACTION_LOGIN") > 0) {
                this.errno = -3;
                this.message = "authentication.error";
                return;
            }
            this.errno = -1;
            this.message = "invalid.document";
            this.exception = new StoradeException("communication.error", new Object[]{xmlDoc});
        }
        if ((index = xmlDoc.indexOf("<ERROR")) >= 0) {
            this.parseNode(XMLUtil.getNode(xmlDoc));
        }
    }

    private void parseNode(Node node) {
        if (node.getNodeType() == 1 && "ERROR".equals(node.getNodeName())) {
            this.message = XMLUtil.getCdata(node);
            try {
                this.errno = Integer.parseInt(XMLUtil.getAttribute(node, "no"));
            }
            catch (Exception e) {
                this.errno = -2;
                this.message = e.getMessage();
            }
        }
    }

    public boolean isError() {
        return this.errno != 0;
    }

    public boolean isOK() {
        return this.errno == 0;
    }

    public int getErrorNumber() {
        return this.errno;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.errno == 0) {
            return "OK";
        }
        return "ERROR (" + this.errno + "): " + this.message;
    }
}

