/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client;

import com.sun.netstorage.fm.storade.client.http.AgentConfigImpl;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.AlarmQueryImpl;
import com.sun.netstorage.fm.storade.client.http.DeviceMaintenanceImpl;
import com.sun.netstorage.fm.storade.client.http.DeviceReportImpl;
import com.sun.netstorage.fm.storade.client.http.DiscoveryCommand;
import com.sun.netstorage.fm.storade.client.http.EventSubscriptionImpl;
import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.LockManagerImpl;
import com.sun.netstorage.fm.storade.client.http.MessagePostImpl;
import com.sun.netstorage.fm.storade.client.http.RawTopoImpl;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.agent.AgentConfigService;
import com.sun.netstorage.fm.storade.service.alarm.AlarmMaintenanceService;
import com.sun.netstorage.fm.storade.service.alarm.AlarmQueryService;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceReportService;
import com.sun.netstorage.fm.storade.service.lock.LockManagerService;
import com.sun.netstorage.fm.storade.util.Environment;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;

public class SAClient {
    private URL agent;
    private String user;
    private String credential;
    private HashMap services;
    private static final String AGENT_CONFIG_NAME = "com.sun.netstorage.fm.storade.service.agent.AgentConfigService";
    private static final String ALARM_NAME = "com.sun.netstorage.fm.storade.service.alarm.AlarmService";
    private static final String DEVICE_MAINTENANCE_NAME = "com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService";
    private static final String DEVICE_REPORT_NAME = "com.sun.netstorage.fm.storade.service.device.DeviceReportService";
    private static final String LOCK_MANAGER_NAME = "com.sun.netstorage.fm.storade.service.lock.LockManagerService";
    public static final String cvs_id = "$Id: SAClient.java,v 1.18 2005/05/05 18:15:52 jkremer Exp $";

    public SAClient() {
        try {
            this.agent = new URL("http://localhost:7654");
        }
        catch (MalformedURLException me) {
            throw new IllegalStateException(me.toString());
        }
        this.setDefaultCredentials();
        this.init();
    }

    public SAClient(URL agent) {
        if (agent == null) {
            throw new IllegalArgumentException();
        }
        this.agent = agent;
        this.setDefaultCredentials();
        this.init();
    }

    public SAClient(URL agent, String user, String credential) {
        if (agent == null) {
            throw new IllegalArgumentException();
        }
        this.agent = agent;
        this.user = user;
        this.credential = credential;
        this.init();
    }

    public SAClient(URI agent) {
        if (agent == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.agent = agent.toURL();
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException(agent.toString());
        }
        String userInfo = agent.getUserInfo();
        if (userInfo == null) {
            this.setDefaultCredentials();
        } else {
            int index = userInfo.indexOf(":");
            if (index > 0) {
                this.user = userInfo.substring(0, index);
                this.credential = userInfo.substring(index + 1);
            } else {
                this.user = userInfo;
            }
        }
        this.init();
    }

    public URL getURL() {
        return this.agent;
    }

    public static URL discoverURL(InetAddress host) throws StoradeException {
        return SAClient.discoverURL(host, Environment.getPeerRole(), Environment.getPeerPass());
    }

    public static URL discoverURL(InetAddress host, String user, String password) throws StoradeException {
        return SAClient.discoverURL(host, user, password, 5);
    }

    public static URL discoverURL(InetAddress host, String user, String password, int timeout) throws StoradeException {
        try {
            URL url = new URL("https", host.getHostName(), 7443, "/");
            if (SAClient.discovered(new HTTPConnection(url, user, password), timeout)) {
                return url;
            }
            url = new URL("http", host.getHostName(), 7654, "/");
            if (SAClient.discovered(new HTTPConnection(url, user, password), timeout)) {
                return url;
            }
            url = new URL("https", host.getHostName(), 6789, "/");
            if (SAClient.discovered(new HTTPConnection(url, user, password), timeout)) {
                return url;
            }
            url = new URL("https", host.getHostName(), 6789, "/storade");
            if (SAClient.discovered(new HTTPConnection(url, user, password), timeout)) {
                return url;
            }
        }
        catch (Exception e) {
            throw new StoradeException("communication.error", e);
        }
        return null;
    }

    private static boolean canConnect(String host, int port, int timeout) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout * 1000);
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean discovered(HTTPConnection http, int timeout) {
        if (!SAClient.canConnect(http.getHost(), http.getPort(), timeout)) {
            return false;
        }
        DiscoveryCommand cmd = new DiscoveryCommand(timeout);
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            return false;
        }
        String data = resp.getData();
        if (data == null) {
            return false;
        }
        return data.startsWith("#<pre>");
    }

    public boolean isAlive() {
        try {
            return SAClient.discovered(this.getConnection(), 20);
        }
        catch (Exception e) {
            return false;
        }
    }

    public AgentConfigService getAgentConfigService() {
        return (AgentConfigService)this.services.get(AGENT_CONFIG_NAME);
    }

    public AlarmQueryService getAlarmQueryService() {
        return (AlarmQueryService)this.services.get(ALARM_NAME);
    }

    public AlarmMaintenanceService getAlarmMaintenanceService() {
        return (AlarmMaintenanceService)this.services.get(ALARM_NAME);
    }

    public DeviceMaintenanceService getDeviceMaintenanceService() {
        return (DeviceMaintenanceService)this.services.get(DEVICE_MAINTENANCE_NAME);
    }

    public DeviceReportService getDeviceReportService() {
        return (DeviceReportService)this.services.get(DEVICE_REPORT_NAME);
    }

    public LockManagerService getLockManagerService() {
        return (LockManagerService)this.services.get(LOCK_MANAGER_NAME);
    }

    public Object getService(String name) {
        return this.services.get(name);
    }

    public String[] getServiceNames() {
        Set keys = this.services.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    private HTTPConnection getConnection() {
        if (this.user == null) {
            return new HTTPConnection(this.agent);
        }
        return new HTTPConnection(this.agent, this.user, this.credential);
    }

    private void setDefaultCredentials() {
        this.user = Environment.getPeerRole();
        this.credential = Environment.getPeerPass();
    }

    private synchronized void init() {
        this.services = new HashMap();
        this.services.put(ALARM_NAME, new AlarmQueryImpl(this.agent, this.user, this.credential));
        this.services.put(DEVICE_MAINTENANCE_NAME, new DeviceMaintenanceImpl(this.agent, this.user, this.credential));
        this.services.put(DEVICE_REPORT_NAME, new DeviceReportImpl(this.agent, this.user, this.credential));
        this.services.put(AGENT_CONFIG_NAME, new AgentConfigImpl(this.agent, this.user, this.credential));
        this.services.put(LOCK_MANAGER_NAME, new LockManagerImpl(this.agent, this.user, this.credential));
        this.services.put("com.sun.netstorage.fm.storade.service.topology.TopologyService", new RawTopoImpl(this.agent, this.user, this.credential));
        this.services.put("com.sun.netstorage.fm.storade.service.message.MessagePostService", new MessagePostImpl(this.agent, this.user, this.credential));
        this.services.put("com.sun.netstorage.fm.storade.service.event.EventSubscriptionService", new EventSubscriptionImpl(this.agent, this.user, this.credential));
    }
}

