/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.VolumeUsage;

public class VolumeUsageHint
implements XDRType,
SYMbolAPIConstants {
    private VolumeUsage usageHint = new VolumeUsage();
    private int segmentSize;
    private int readAhead;

    public VolumeUsageHint() {
    }

    public VolumeUsageHint(VolumeUsageHint volumeUsageHint) {
        this.usageHint = volumeUsageHint.usageHint;
        this.segmentSize = volumeUsageHint.segmentSize;
        this.readAhead = volumeUsageHint.readAhead;
    }

    public VolumeUsage getUsageHint() {
        return this.usageHint;
    }

    public void setUsageHint(VolumeUsage volumeUsage) {
        this.usageHint = volumeUsage;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.usageHint.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.segmentSize);
        xDROutputStream.putInt(this.readAhead);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.usageHint.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.segmentSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.readAhead = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

