/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.VolumeGroupRef;

public class VolumeGroup
implements XDRType,
SYMbolAPIConstants {
    private int sequenceNum;
    private boolean offline;
    private RAIDLevel raidLevel = new RAIDLevel();
    private byte[] worldWideName;
    private VolumeGroupRef volumeGroupRef = new VolumeGroupRef();
    private byte[] reserved1;
    private byte[] reserved2;
    private boolean trayLossProtection;

    public VolumeGroup() {
    }

    public VolumeGroup(VolumeGroup volumeGroup) {
        this.sequenceNum = volumeGroup.sequenceNum;
        this.offline = volumeGroup.offline;
        this.raidLevel = volumeGroup.raidLevel;
        this.worldWideName = volumeGroup.worldWideName;
        this.volumeGroupRef = volumeGroup.volumeGroupRef;
        this.reserved1 = volumeGroup.reserved1;
        this.reserved2 = volumeGroup.reserved2;
        this.trayLossProtection = volumeGroup.trayLossProtection;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(int n) {
        this.sequenceNum = n;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public RAIDLevel getRaidLevel() {
        return this.raidLevel;
    }

    public void setRaidLevel(RAIDLevel rAIDLevel) {
        this.raidLevel = rAIDLevel;
    }

    public byte[] getWorldWideName() {
        return this.worldWideName;
    }

    public void setWorldWideName(byte[] byArray) {
        this.worldWideName = byArray;
    }

    public VolumeGroupRef getVolumeGroupRef() {
        return this.volumeGroupRef;
    }

    public void setVolumeGroupRef(VolumeGroupRef volumeGroupRef) {
        this.volumeGroupRef = volumeGroupRef;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public boolean getTrayLossProtection() {
        return this.trayLossProtection;
    }

    public void setTrayLossProtection(boolean bl) {
        this.trayLossProtection = bl;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.sequenceNum);
        xDROutputStream.putBoolean(this.offline);
        this.raidLevel.xdrEncode(xDROutputStream);
        xDROutputStream.putVariableOpaque(this.worldWideName);
        this.volumeGroupRef.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.putBoolean(this.trayLossProtection);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.sequenceNum = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.offline = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.raidLevel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.worldWideName = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.trayLossProtection = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

