/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.VolumeCandidate;

public class VolumeCreationDescriptor
implements XDRType,
SYMbolAPIConstants {
    private VolumeCandidate candidate = new VolumeCandidate();
    private UserAssignedLabel label = new UserAssignedLabel();
    private ControllerRef manager = new ControllerRef();
    private long capacity;
    private int segmentSize;
    private int readAhead;
    private boolean writeZeros;
    private boolean noMapping;

    public VolumeCreationDescriptor() {
    }

    public VolumeCreationDescriptor(VolumeCreationDescriptor volumeCreationDescriptor) {
        this.candidate = volumeCreationDescriptor.candidate;
        this.label = volumeCreationDescriptor.label;
        this.manager = volumeCreationDescriptor.manager;
        this.capacity = volumeCreationDescriptor.capacity;
        this.segmentSize = volumeCreationDescriptor.segmentSize;
        this.readAhead = volumeCreationDescriptor.readAhead;
        this.writeZeros = volumeCreationDescriptor.writeZeros;
        this.noMapping = volumeCreationDescriptor.noMapping;
    }

    public VolumeCandidate getCandidate() {
        return this.candidate;
    }

    public void setCandidate(VolumeCandidate volumeCandidate) {
        this.candidate = volumeCandidate;
    }

    public UserAssignedLabel getLabel() {
        return this.label;
    }

    public void setLabel(UserAssignedLabel userAssignedLabel) {
        this.label = userAssignedLabel;
    }

    public ControllerRef getManager() {
        return this.manager;
    }

    public void setManager(ControllerRef controllerRef) {
        this.manager = controllerRef;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long l) {
        this.capacity = l;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public boolean getWriteZeros() {
        return this.writeZeros;
    }

    public void setWriteZeros(boolean bl) {
        this.writeZeros = bl;
    }

    public boolean getNoMapping() {
        return this.noMapping;
    }

    public void setNoMapping(boolean bl) {
        this.noMapping = bl;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.candidate.xdrEncode(xDROutputStream);
        this.label.xdrEncode(xDROutputStream);
        this.manager.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.capacity);
        xDROutputStream.putInt(this.segmentSize);
        xDROutputStream.putInt(this.readAhead);
        xDROutputStream.putBoolean(this.writeZeros);
        xDROutputStream.putBoolean(this.noMapping);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.candidate.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.label.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.manager.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.capacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.segmentSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.readAhead = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.writeZeros = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.noMapping = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

