/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ChannelType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class SocLocation
implements XDRType,
SYMbolAPIConstants {
    private ChannelType channelType = new ChannelType();
    private int channel;
    private int soc;
    private int port;
    private int controllerSlot;

    public SocLocation() {
    }

    public SocLocation(SocLocation socLocation) {
        this.channelType = socLocation.channelType;
        this.channel = socLocation.channel;
        this.soc = socLocation.soc;
        this.port = socLocation.port;
        this.controllerSlot = socLocation.controllerSlot;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getSoc() {
        return this.soc;
    }

    public void setSoc(int n) {
        this.soc = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getControllerSlot() {
        return this.controllerSlot;
    }

    public void setControllerSlot(int n) {
        this.controllerSlot = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.channelType.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.soc);
        xDROutputStream.putInt(this.port);
        xDROutputStream.putInt(this.controllerSlot);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channelType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.soc = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.port = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.controllerSlot = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

