/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.SocParent;

public class SocDeviceData
implements XDRType,
SYMbolAPIConstants {
    private SocParent parent = new SocParent();
    private boolean hubMode;
    private boolean managedMode;
    private int collectionElapsedTime;

    public SocDeviceData() {
    }

    public SocDeviceData(SocDeviceData socDeviceData) {
        this.parent = socDeviceData.parent;
        this.hubMode = socDeviceData.hubMode;
        this.managedMode = socDeviceData.managedMode;
        this.collectionElapsedTime = socDeviceData.collectionElapsedTime;
    }

    public SocParent getParent() {
        return this.parent;
    }

    public void setParent(SocParent socParent) {
        this.parent = socParent;
    }

    public boolean getHubMode() {
        return this.hubMode;
    }

    public void setHubMode(boolean bl) {
        this.hubMode = bl;
    }

    public boolean getManagedMode() {
        return this.managedMode;
    }

    public void setManagedMode(boolean bl) {
        this.managedMode = bl;
    }

    public int getCollectionElapsedTime() {
        return this.collectionElapsedTime;
    }

    public void setCollectionElapsedTime(int n) {
        this.collectionElapsedTime = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.parent.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.hubMode);
        xDROutputStream.putBoolean(this.managedMode);
        xDROutputStream.putInt(this.collectionElapsedTime);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.parent.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.hubMode = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.managedMode = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.collectionElapsedTime = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

