/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.RepositoryFullPolicy;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.SnapshotRef;

public class SnapshotParamsUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private SnapshotRef snapRef = new SnapshotRef();
    private int warnThreshold;
    private long extentStart;
    private long extentSize;
    private RepositoryFullPolicy repFullPolicy = new RepositoryFullPolicy();
    private int rollbackPriority;

    public SnapshotParamsUpdateDescriptor() {
    }

    public SnapshotParamsUpdateDescriptor(SnapshotParamsUpdateDescriptor snapshotParamsUpdateDescriptor) {
        this.snapRef = snapshotParamsUpdateDescriptor.snapRef;
        this.warnThreshold = snapshotParamsUpdateDescriptor.warnThreshold;
        this.extentStart = snapshotParamsUpdateDescriptor.extentStart;
        this.extentSize = snapshotParamsUpdateDescriptor.extentSize;
        this.repFullPolicy = snapshotParamsUpdateDescriptor.repFullPolicy;
        this.rollbackPriority = snapshotParamsUpdateDescriptor.rollbackPriority;
    }

    public SnapshotRef getSnapRef() {
        return this.snapRef;
    }

    public void setSnapRef(SnapshotRef snapshotRef) {
        this.snapRef = snapshotRef;
    }

    public int getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setWarnThreshold(int n) {
        this.warnThreshold = n;
    }

    public long getExtentStart() {
        return this.extentStart;
    }

    public void setExtentStart(long l) {
        this.extentStart = l;
    }

    public long getExtentSize() {
        return this.extentSize;
    }

    public void setExtentSize(long l) {
        this.extentSize = l;
    }

    public RepositoryFullPolicy getRepFullPolicy() {
        return this.repFullPolicy;
    }

    public void setRepFullPolicy(RepositoryFullPolicy repositoryFullPolicy) {
        this.repFullPolicy = repositoryFullPolicy;
    }

    public int getRollbackPriority() {
        return this.rollbackPriority;
    }

    public void setRollbackPriority(int n) {
        this.rollbackPriority = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.snapRef.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.warnThreshold);
        xDROutputStream.putLong(this.extentStart);
        xDROutputStream.putLong(this.extentSize);
        this.repFullPolicy.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.rollbackPriority);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.snapRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.warnThreshold = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentStart = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentSize = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.repFullPolicy.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.rollbackPriority = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

