/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.ScsiToAtaTranslatorData;

public class SataDriveAttributes
implements XDRType,
SYMbolAPIConstants {
    private ScsiToAtaTranslatorData translatorData = new ScsiToAtaTranslatorData();
    private String ataDiskModelNumber;
    private String ataDiskFwRevision;

    public SataDriveAttributes() {
    }

    public SataDriveAttributes(SataDriveAttributes sataDriveAttributes) {
        this.translatorData = sataDriveAttributes.translatorData;
        this.ataDiskModelNumber = sataDriveAttributes.ataDiskModelNumber;
        this.ataDiskFwRevision = sataDriveAttributes.ataDiskFwRevision;
    }

    public ScsiToAtaTranslatorData getTranslatorData() {
        return this.translatorData;
    }

    public void setTranslatorData(ScsiToAtaTranslatorData scsiToAtaTranslatorData) {
        this.translatorData = scsiToAtaTranslatorData;
    }

    public String getAtaDiskModelNumber() {
        return this.ataDiskModelNumber;
    }

    public void setAtaDiskModelNumber(String string) {
        this.ataDiskModelNumber = string;
    }

    public String getAtaDiskFwRevision() {
        return this.ataDiskFwRevision;
    }

    public void setAtaDiskFwRevision(String string) {
        this.ataDiskFwRevision = string;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.translatorData.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.ataDiskModelNumber);
        xDROutputStream.putString(this.ataDiskFwRevision);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.translatorData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.ataDiskModelNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.ataDiskFwRevision = xDRInputStream.getString();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

