/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SAPortGroupRef;
import devmgr.versioned.symbol.SAPortRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class SAPort
implements XDRType,
SYMbolAPIConstants {
    private SAPortRef saPortRef = new SAPortRef();
    private SAPortGroupRef saPortGroupRef = new SAPortGroupRef();
    private ControllerRef controllerRef = new ControllerRef();
    private int portId;

    public SAPort() {
    }

    public SAPort(SAPort sAPort) {
        this.saPortRef = sAPort.saPortRef;
        this.saPortGroupRef = sAPort.saPortGroupRef;
        this.controllerRef = sAPort.controllerRef;
        this.portId = sAPort.portId;
    }

    public SAPortRef getSaPortRef() {
        return this.saPortRef;
    }

    public void setSaPortRef(SAPortRef sAPortRef) {
        this.saPortRef = sAPortRef;
    }

    public SAPortGroupRef getSaPortGroupRef() {
        return this.saPortGroupRef;
    }

    public void setSaPortGroupRef(SAPortGroupRef sAPortGroupRef) {
        this.saPortGroupRef = sAPortGroupRef;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public int getPortId() {
        return this.portId;
    }

    public void setPortId(int n) {
        this.portId = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.saPortRef.xdrEncode(xDROutputStream);
        this.saPortGroupRef.xdrEncode(xDROutputStream);
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.portId);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.saPortRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.saPortGroupRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.portId = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

