/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class SACache
implements XDRType,
SYMbolAPIConstants {
    private int cacheBlkSize;
    private int demandFlushAmount;
    private int demandFlushThreshold;
    private byte[] reserved1;
    private byte[] reserved2;

    public SACache() {
    }

    public SACache(SACache sACache) {
        this.cacheBlkSize = sACache.cacheBlkSize;
        this.demandFlushAmount = sACache.demandFlushAmount;
        this.demandFlushThreshold = sACache.demandFlushThreshold;
        this.reserved1 = sACache.reserved1;
        this.reserved2 = sACache.reserved2;
    }

    public int getCacheBlkSize() {
        return this.cacheBlkSize;
    }

    public void setCacheBlkSize(int n) {
        this.cacheBlkSize = n;
    }

    public int getDemandFlushAmount() {
        return this.demandFlushAmount;
    }

    public void setDemandFlushAmount(int n) {
        this.demandFlushAmount = n;
    }

    public int getDemandFlushThreshold() {
        return this.demandFlushThreshold;
    }

    public void setDemandFlushThreshold(int n) {
        this.demandFlushThreshold = n;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.cacheBlkSize);
        xDROutputStream.putInt(this.demandFlushAmount);
        xDROutputStream.putInt(this.demandFlushThreshold);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.cacheBlkSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.demandFlushAmount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.demandFlushThreshold = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

