/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.UserAssignedLabel;

public class RecoverVolumeDescriptor
implements XDRType,
SYMbolAPIConstants {
    private UserAssignedLabel label = new UserAssignedLabel();
    private ControllerRef manager = new ControllerRef();
    private long capacity;
    private RAIDLevel raidLevel = new RAIDLevel();
    private int segmentSize;
    private int readAhead;
    private long offset;
    private int volumeGroupNumber;
    private int driveCount;
    private DriveRefList driveRefList = new DriveRefList();

    public RecoverVolumeDescriptor() {
    }

    public RecoverVolumeDescriptor(RecoverVolumeDescriptor recoverVolumeDescriptor) {
        this.label = recoverVolumeDescriptor.label;
        this.manager = recoverVolumeDescriptor.manager;
        this.capacity = recoverVolumeDescriptor.capacity;
        this.raidLevel = recoverVolumeDescriptor.raidLevel;
        this.segmentSize = recoverVolumeDescriptor.segmentSize;
        this.readAhead = recoverVolumeDescriptor.readAhead;
        this.offset = recoverVolumeDescriptor.offset;
        this.volumeGroupNumber = recoverVolumeDescriptor.volumeGroupNumber;
        this.driveCount = recoverVolumeDescriptor.driveCount;
        this.driveRefList = recoverVolumeDescriptor.driveRefList;
    }

    public UserAssignedLabel getLabel() {
        return this.label;
    }

    public void setLabel(UserAssignedLabel userAssignedLabel) {
        this.label = userAssignedLabel;
    }

    public ControllerRef getManager() {
        return this.manager;
    }

    public void setManager(ControllerRef controllerRef) {
        this.manager = controllerRef;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long l) {
        this.capacity = l;
    }

    public RAIDLevel getRaidLevel() {
        return this.raidLevel;
    }

    public void setRaidLevel(RAIDLevel rAIDLevel) {
        this.raidLevel = rAIDLevel;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public int getVolumeGroupNumber() {
        return this.volumeGroupNumber;
    }

    public void setVolumeGroupNumber(int n) {
        this.volumeGroupNumber = n;
    }

    public int getDriveCount() {
        return this.driveCount;
    }

    public void setDriveCount(int n) {
        this.driveCount = n;
    }

    public DriveRefList getDriveRefList() {
        return this.driveRefList;
    }

    public void setDriveRefList(DriveRefList driveRefList) {
        this.driveRefList = driveRefList;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.label.xdrEncode(xDROutputStream);
        this.manager.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.capacity);
        this.raidLevel.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.segmentSize);
        xDROutputStream.putInt(this.readAhead);
        xDROutputStream.putLong(this.offset);
        xDROutputStream.putInt(this.volumeGroupNumber);
        xDROutputStream.putInt(this.driveCount);
        this.driveRefList.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.label.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.manager.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.capacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.raidLevel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.segmentSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.readAhead = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.offset = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupNumber = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.driveCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.driveRefList.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

