/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.RLSCount;
import devmgr.versioned.symbol.RLSDevice;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class RLSData
implements XDRType,
SYMbolAPIConstants {
    private RLSDevice device = new RLSDevice();
    private int channel;
    private int loopMapIndex;
    private RLSCount rlsCount = new RLSCount();
    private long baselineTime;
    private boolean valid;

    public RLSData() {
    }

    public RLSData(RLSData rLSData) {
        this.device = rLSData.device;
        this.channel = rLSData.channel;
        this.loopMapIndex = rLSData.loopMapIndex;
        this.rlsCount = rLSData.rlsCount;
        this.baselineTime = rLSData.baselineTime;
        this.valid = rLSData.valid;
    }

    public RLSDevice getDevice() {
        return this.device;
    }

    public void setDevice(RLSDevice rLSDevice) {
        this.device = rLSDevice;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getLoopMapIndex() {
        return this.loopMapIndex;
    }

    public void setLoopMapIndex(int n) {
        this.loopMapIndex = n;
    }

    public RLSCount getRlsCount() {
        return this.rlsCount;
    }

    public void setRlsCount(RLSCount rLSCount) {
        this.rlsCount = rLSCount;
    }

    public long getBaselineTime() {
        return this.baselineTime;
    }

    public void setBaselineTime(long l) {
        this.baselineTime = l;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.device.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.loopMapIndex);
        this.rlsCount.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.baselineTime);
        xDROutputStream.putBoolean(this.valid);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.device.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.loopMapIndex = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rlsCount.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.baselineTime = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.valid = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

