/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.RLSCommand;
import devmgr.versioned.symbol.RLSDevices;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class RLSCommandDescriptor
implements XDRType,
SYMbolAPIConstants {
    private RLSCommand command = new RLSCommand();
    private int[] channels;
    private RLSDevices devices = new RLSDevices();

    public RLSCommandDescriptor() {
    }

    public RLSCommandDescriptor(RLSCommandDescriptor rLSCommandDescriptor) {
        this.channels = rLSCommandDescriptor.channels;
        this.devices = rLSCommandDescriptor.devices;
    }

    public RLSCommand getCommand() {
        return this.command;
    }

    public void setCommand(RLSCommand rLSCommand) {
        this.command = rLSCommand;
    }

    public int[] getChannels() {
        return this.channels;
    }

    public void setChannels(int[] nArray) {
        this.channels = nArray;
    }

    public RLSDevices getDevices() {
        return this.devices;
    }

    public void setDevices(RLSDevices rLSDevices) {
        this.devices = rLSDevices;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.command.xdrEncode(xDROutputStream);
        switch (this.command.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                int n2 = this.channels == null ? 0 : this.channels.length;
                xDROutputStream.putInt(n2);
                int n3 = 0;
                while (n3 < n2) {
                    xDROutputStream.putInt(this.channels[n3]);
                    ++n3;
                }
                break;
            }
            case 3: {
                this.devices.xdrEncode(xDROutputStream);
                break;
            }
        }
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        this.command.xdrDecode(xDRInputStream);
        switch (this.command.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                int n2 = xDRInputStream.getInt();
                this.channels = new int[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this.channels[n3] = xDRInputStream.getInt();
                    ++n3;
                }
                break;
            }
            case 3: {
                this.devices.xdrDecode(xDRInputStream);
                break;
            }
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

