/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.InterfaceSpeed;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.MinihubStatus;
import devmgr.versioned.symbol.MinihubTypeData;
import devmgr.versioned.symbol.PortList;
import devmgr.versioned.symbol.RTRAttributes;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Minihub
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef minihubRef = new ComponentRef();
    private MinihubStatus status = new MinihubStatus();
    private Location physicalLocation = new Location();
    private MinihubTypeData minihubData = new MinihubTypeData();
    private InterfaceSpeed currentSpeed = new InterfaceSpeed();
    private InterfaceSpeed maxSpeed = new InterfaceSpeed();
    private int channel;
    private PortList portList = new PortList();
    private String vendorName;
    private String partNumber;
    private String serialNumber;
    private String fruType;
    private long manufacturerDate;
    private byte[] reserved1;
    private byte[] reserved2;
    private RTRAttributes rtrAttributes = new RTRAttributes();

    public Minihub() {
    }

    public Minihub(Minihub minihub) {
        this.minihubRef = minihub.minihubRef;
        this.status = minihub.status;
        this.physicalLocation = minihub.physicalLocation;
        this.minihubData = minihub.minihubData;
        this.currentSpeed = minihub.currentSpeed;
        this.maxSpeed = minihub.maxSpeed;
        this.channel = minihub.channel;
        this.portList = minihub.portList;
        this.vendorName = minihub.vendorName;
        this.partNumber = minihub.partNumber;
        this.serialNumber = minihub.serialNumber;
        this.fruType = minihub.fruType;
        this.manufacturerDate = minihub.manufacturerDate;
        this.reserved1 = minihub.reserved1;
        this.reserved2 = minihub.reserved2;
        this.rtrAttributes = minihub.rtrAttributes;
    }

    public ComponentRef getMinihubRef() {
        return this.minihubRef;
    }

    public void setMinihubRef(ComponentRef componentRef) {
        this.minihubRef = componentRef;
    }

    public MinihubStatus getStatus() {
        return this.status;
    }

    public void setStatus(MinihubStatus minihubStatus) {
        this.status = minihubStatus;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public MinihubTypeData getMinihubData() {
        return this.minihubData;
    }

    public void setMinihubData(MinihubTypeData minihubTypeData) {
        this.minihubData = minihubTypeData;
    }

    public InterfaceSpeed getCurrentSpeed() {
        return this.currentSpeed;
    }

    public void setCurrentSpeed(InterfaceSpeed interfaceSpeed) {
        this.currentSpeed = interfaceSpeed;
    }

    public InterfaceSpeed getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(InterfaceSpeed interfaceSpeed) {
        this.maxSpeed = interfaceSpeed;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public PortList getPortList() {
        return this.portList;
    }

    public void setPortList(PortList portList) {
        this.portList = portList;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public String getFruType() {
        return this.fruType;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public RTRAttributes getRtrAttributes() {
        return this.rtrAttributes;
    }

    public void setRtrAttributes(RTRAttributes rTRAttributes) {
        this.rtrAttributes = rTRAttributes;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.minihubRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        this.minihubData.xdrEncode(xDROutputStream);
        this.currentSpeed.xdrEncode(xDROutputStream);
        this.maxSpeed.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        this.portList.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.vendorName);
        xDROutputStream.putString(this.partNumber);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putString(this.fruType);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        this.rtrAttributes.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.minihubRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.minihubData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.maxSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.portList.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.partNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rtrAttributes.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

