/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SFP_CONNECT_TYPE;
import devmgr.versioned.symbol.SFP_SPEED;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class LinkSpeedDetectionError
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef parentRef = new ControllerRef();
    private int channel;
    private int channelPort;
    private SFP_CONNECT_TYPE connector = new SFP_CONNECT_TYPE();
    private SFP_SPEED supportedLinkSpeeds = new SFP_SPEED();
    private int currentLinkSpeed;
    private boolean manuallyBypassed;
    private boolean supportsSpeed;

    public LinkSpeedDetectionError() {
    }

    public LinkSpeedDetectionError(LinkSpeedDetectionError linkSpeedDetectionError) {
        this.parentRef = linkSpeedDetectionError.parentRef;
        this.channel = linkSpeedDetectionError.channel;
        this.channelPort = linkSpeedDetectionError.channelPort;
        this.connector = linkSpeedDetectionError.connector;
        this.supportedLinkSpeeds = linkSpeedDetectionError.supportedLinkSpeeds;
        this.currentLinkSpeed = linkSpeedDetectionError.currentLinkSpeed;
        this.manuallyBypassed = linkSpeedDetectionError.manuallyBypassed;
        this.supportsSpeed = linkSpeedDetectionError.supportsSpeed;
    }

    public ControllerRef getParentRef() {
        return this.parentRef;
    }

    public void setParentRef(ControllerRef controllerRef) {
        this.parentRef = controllerRef;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getChannelPort() {
        return this.channelPort;
    }

    public void setChannelPort(int n) {
        this.channelPort = n;
    }

    public SFP_CONNECT_TYPE getConnector() {
        return this.connector;
    }

    public void setConnector(SFP_CONNECT_TYPE sFP_CONNECT_TYPE) {
        this.connector = sFP_CONNECT_TYPE;
    }

    public SFP_SPEED getSupportedLinkSpeeds() {
        return this.supportedLinkSpeeds;
    }

    public void setSupportedLinkSpeeds(SFP_SPEED sFP_SPEED) {
        this.supportedLinkSpeeds = sFP_SPEED;
    }

    public int getCurrentLinkSpeed() {
        return this.currentLinkSpeed;
    }

    public void setCurrentLinkSpeed(int n) {
        this.currentLinkSpeed = n;
    }

    public boolean getManuallyBypassed() {
        return this.manuallyBypassed;
    }

    public void setManuallyBypassed(boolean bl) {
        this.manuallyBypassed = bl;
    }

    public boolean getSupportsSpeed() {
        return this.supportsSpeed;
    }

    public void setSupportsSpeed(boolean bl) {
        this.supportsSpeed = bl;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.parentRef.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.channelPort);
        this.connector.xdrEncode(xDROutputStream);
        this.supportedLinkSpeeds.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.currentLinkSpeed);
        xDROutputStream.putBoolean(this.manuallyBypassed);
        xDROutputStream.putBoolean(this.supportsSpeed);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.parentRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.channelPort = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.connector.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.supportedLinkSpeeds.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentLinkSpeed = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manuallyBypassed = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.supportsSpeed = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

