/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.HostBoardStatus;
import devmgr.versioned.symbol.HostBoardType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class HostBoard
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef parentController = new ControllerRef();
    private String partNumber;
    private String serialNumber;
    private String vendorName;
    private long manufacturerDate;
    private String fruType;
    private String hostBoardId;
    private HostBoardStatus status = new HostBoardStatus();
    private HostBoardType type = new HostBoardType();
    private ComponentRef hostBoardRef = new ComponentRef();

    public HostBoard() {
    }

    public HostBoard(HostBoard hostBoard) {
        this.parentController = hostBoard.parentController;
        this.partNumber = hostBoard.partNumber;
        this.serialNumber = hostBoard.serialNumber;
        this.vendorName = hostBoard.vendorName;
        this.manufacturerDate = hostBoard.manufacturerDate;
        this.fruType = hostBoard.fruType;
        this.hostBoardId = hostBoard.hostBoardId;
        this.status = hostBoard.status;
        this.type = hostBoard.type;
        this.hostBoardRef = hostBoard.hostBoardRef;
    }

    public ControllerRef getParentController() {
        return this.parentController;
    }

    public void setParentController(ControllerRef controllerRef) {
        this.parentController = controllerRef;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public String getFruType() {
        return this.fruType;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public String getHostBoardId() {
        return this.hostBoardId;
    }

    public void setHostBoardId(String string) {
        this.hostBoardId = string;
    }

    public HostBoardStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostBoardStatus hostBoardStatus) {
        this.status = hostBoardStatus;
    }

    public HostBoardType getType() {
        return this.type;
    }

    public void setType(HostBoardType hostBoardType) {
        this.type = hostBoardType;
    }

    public ComponentRef getHostBoardRef() {
        return this.hostBoardRef;
    }

    public void setHostBoardRef(ComponentRef componentRef) {
        this.hostBoardRef = componentRef;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.parentController.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.partNumber);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putString(this.vendorName);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.fruType);
        xDROutputStream.putString(this.hostBoardId);
        this.status.xdrEncode(xDROutputStream);
        this.type.xdrEncode(xDROutputStream);
        this.hostBoardRef.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.parentController.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.partNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.hostBoardId = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.type.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.hostBoardRef.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

