/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.GhostVolRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class GhostVolume
implements XDRType,
SYMbolAPIConstants {
    private byte[] worldWideName;
    private GhostVolRef volumeRef = new GhostVolRef();
    private byte[] reserved1;
    private byte[] reserved2;

    public GhostVolume() {
    }

    public GhostVolume(GhostVolume ghostVolume) {
        this.worldWideName = ghostVolume.worldWideName;
        this.volumeRef = ghostVolume.volumeRef;
        this.reserved1 = ghostVolume.reserved1;
        this.reserved2 = ghostVolume.reserved2;
    }

    public byte[] getWorldWideName() {
        return this.worldWideName;
    }

    public void setWorldWideName(byte[] byArray) {
        this.worldWideName = byArray;
    }

    public GhostVolRef getVolumeRef() {
        return this.volumeRef;
    }

    public void setVolumeRef(GhostVolRef ghostVolRef) {
        this.volumeRef = ghostVolRef;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putVariableOpaque(this.worldWideName);
        this.volumeRef.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.worldWideName = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

