/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class EthernetParamsUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef controllerRef = new ControllerRef();
    private String interfaceName;
    private int channel;
    private int ip;
    private int gatewayIp;
    private int subnetMask;

    public EthernetParamsUpdateDescriptor() {
    }

    public EthernetParamsUpdateDescriptor(EthernetParamsUpdateDescriptor ethernetParamsUpdateDescriptor) {
        this.controllerRef = ethernetParamsUpdateDescriptor.controllerRef;
        this.interfaceName = ethernetParamsUpdateDescriptor.interfaceName;
        this.channel = ethernetParamsUpdateDescriptor.channel;
        this.ip = ethernetParamsUpdateDescriptor.ip;
        this.gatewayIp = ethernetParamsUpdateDescriptor.gatewayIp;
        this.subnetMask = ethernetParamsUpdateDescriptor.subnetMask;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getIp() {
        return this.ip;
    }

    public void setIp(int n) {
        this.ip = n;
    }

    public int getGatewayIp() {
        return this.gatewayIp;
    }

    public void setGatewayIp(int n) {
        this.gatewayIp = n;
    }

    public int getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(int n) {
        this.subnetMask = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.interfaceName);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.ip);
        xDROutputStream.putInt(this.gatewayIp);
        xDROutputStream.putInt(this.subnetMask);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.interfaceName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.ip = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.gatewayIp = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.subnetMask = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

