/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.ESMInterfaceTypeData;
import devmgr.versioned.symbol.ESMStatus;
import devmgr.versioned.symbol.EsmInterfaceAttributes;
import devmgr.versioned.symbol.FibreESMAddress;
import devmgr.versioned.symbol.InterfaceSpeed;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.RTRAttributes;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Esm
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef esmRef = new ComponentRef();
    private ESMStatus status = new ESMStatus();
    private Location physicalLocation = new Location();
    private boolean nonRedundantAccess;
    private String partNumber;
    private String serialNumber;
    private long manufacturerDate;
    private String manufacturer;
    private String fruType;
    private String softwareVersion;
    private ESMInterfaceTypeData esmInterfaceData = new ESMInterfaceTypeData();
    private String productID;
    private int workingChannel;
    private InterfaceSpeed currentSpeed = new InterfaceSpeed();
    private InterfaceSpeed maxSpeed = new InterfaceSpeed();
    private byte[] reserved1;
    private byte[] reserved2;
    private FibreESMAddress fibreEsm = new FibreESMAddress();
    private RTRAttributes rtrAttributes = new RTRAttributes();
    private EsmInterfaceAttributes esmInterfaceAttributes = new EsmInterfaceAttributes();

    public Esm() {
    }

    public Esm(Esm esm) {
        this.esmRef = esm.esmRef;
        this.status = esm.status;
        this.physicalLocation = esm.physicalLocation;
        this.nonRedundantAccess = esm.nonRedundantAccess;
        this.partNumber = esm.partNumber;
        this.serialNumber = esm.serialNumber;
        this.manufacturerDate = esm.manufacturerDate;
        this.manufacturer = esm.manufacturer;
        this.fruType = esm.fruType;
        this.softwareVersion = esm.softwareVersion;
        this.esmInterfaceData = esm.esmInterfaceData;
        this.productID = esm.productID;
        this.workingChannel = esm.workingChannel;
        this.currentSpeed = esm.currentSpeed;
        this.maxSpeed = esm.maxSpeed;
        this.reserved1 = esm.reserved1;
        this.reserved2 = esm.reserved2;
        this.fibreEsm = esm.fibreEsm;
        this.rtrAttributes = esm.rtrAttributes;
        this.esmInterfaceAttributes = esm.esmInterfaceAttributes;
    }

    public ComponentRef getEsmRef() {
        return this.esmRef;
    }

    public void setEsmRef(ComponentRef componentRef) {
        this.esmRef = componentRef;
    }

    public ESMStatus getStatus() {
        return this.status;
    }

    public void setStatus(ESMStatus eSMStatus) {
        this.status = eSMStatus;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public boolean getNonRedundantAccess() {
        return this.nonRedundantAccess;
    }

    public void setNonRedundantAccess(boolean bl) {
        this.nonRedundantAccess = bl;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public String getFruType() {
        return this.fruType;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String string) {
        this.softwareVersion = string;
    }

    public ESMInterfaceTypeData getEsmInterfaceData() {
        return this.esmInterfaceData;
    }

    public void setEsmInterfaceData(ESMInterfaceTypeData eSMInterfaceTypeData) {
        this.esmInterfaceData = eSMInterfaceTypeData;
    }

    public String getProductID() {
        return this.productID;
    }

    public void setProductID(String string) {
        this.productID = string;
    }

    public int getWorkingChannel() {
        return this.workingChannel;
    }

    public void setWorkingChannel(int n) {
        this.workingChannel = n;
    }

    public InterfaceSpeed getCurrentSpeed() {
        return this.currentSpeed;
    }

    public void setCurrentSpeed(InterfaceSpeed interfaceSpeed) {
        this.currentSpeed = interfaceSpeed;
    }

    public InterfaceSpeed getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(InterfaceSpeed interfaceSpeed) {
        this.maxSpeed = interfaceSpeed;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public FibreESMAddress getFibreEsm() {
        return this.fibreEsm;
    }

    public void setFibreEsm(FibreESMAddress fibreESMAddress) {
        this.fibreEsm = fibreESMAddress;
    }

    public RTRAttributes getRtrAttributes() {
        return this.rtrAttributes;
    }

    public void setRtrAttributes(RTRAttributes rTRAttributes) {
        this.rtrAttributes = rTRAttributes;
    }

    public EsmInterfaceAttributes getEsmInterfaceAttributes() {
        return this.esmInterfaceAttributes;
    }

    public void setEsmInterfaceAttributes(EsmInterfaceAttributes esmInterfaceAttributes) {
        this.esmInterfaceAttributes = esmInterfaceAttributes;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.esmRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.nonRedundantAccess);
        xDROutputStream.putString(this.partNumber);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.manufacturer);
        xDROutputStream.putString(this.fruType);
        xDROutputStream.putString(this.softwareVersion);
        this.esmInterfaceData.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.productID);
        xDROutputStream.putInt(this.workingChannel);
        this.currentSpeed.xdrEncode(xDROutputStream);
        this.maxSpeed.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        this.fibreEsm.xdrEncode(xDROutputStream);
        this.rtrAttributes.xdrEncode(xDROutputStream);
        this.esmInterfaceAttributes.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.esmRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.nonRedundantAccess = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.partNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturer = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.softwareVersion = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.esmInterfaceData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.productID = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.workingChannel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.maxSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fibreEsm.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.rtrAttributes.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.esmInterfaceAttributes.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

