/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.DriveType;
import devmgr.versioned.symbol.FibreDriveAddress;
import devmgr.versioned.symbol.SCSIDriveAddress;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class DriveTypeData
implements XDRType,
SYMbolAPIConstants {
    private DriveType driveType = new DriveType();
    private FibreDriveAddress[] fibre;
    private SCSIDriveAddress scsi = new SCSIDriveAddress();

    public DriveTypeData() {
    }

    public DriveTypeData(DriveTypeData driveTypeData) {
        this.fibre = driveTypeData.fibre;
        this.scsi = driveTypeData.scsi;
    }

    public DriveType getDriveType() {
        return this.driveType;
    }

    public void setDriveType(DriveType driveType) {
        this.driveType = driveType;
    }

    public FibreDriveAddress[] getFibre() {
        return this.fibre;
    }

    public void setFibre(FibreDriveAddress[] fibreDriveAddressArray) {
        this.fibre = fibreDriveAddressArray;
    }

    public SCSIDriveAddress getScsi() {
        return this.scsi;
    }

    public void setScsi(SCSIDriveAddress sCSIDriveAddress) {
        this.scsi = sCSIDriveAddress;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.driveType.xdrEncode(xDROutputStream);
        switch (this.driveType.getValue()) {
            case 2: {
                int n2 = this.fibre == null ? 0 : this.fibre.length;
                xDROutputStream.putInt(n2);
                int n3 = 0;
                while (n3 < n2) {
                    this.fibre[n3].xdrEncode(xDROutputStream);
                    ++n3;
                }
                break;
            }
            case 1: {
                this.scsi.xdrEncode(xDROutputStream);
                break;
            }
            case 3: {
                break;
            }
        }
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        this.driveType.xdrDecode(xDRInputStream);
        switch (this.driveType.getValue()) {
            case 2: {
                int n2 = xDRInputStream.getInt();
                this.fibre = new FibreDriveAddress[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this.fibre[n3] = new FibreDriveAddress();
                    this.fibre[n3].xdrDecode(xDRInputStream);
                    ++n3;
                }
                break;
            }
            case 1: {
                this.scsi.xdrDecode(xDRInputStream);
                break;
            }
            case 3: {
                break;
            }
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

