/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DriveChannelDegradeReason;
import devmgr.versioned.symbol.DriveChannelState;
import devmgr.versioned.symbol.DriveChannelStatistics;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class DriveChannel
implements XDRType,
SYMbolAPIConstants {
    private int channel;
    private DriveChannelState state = new DriveChannelState();
    private DriveChannelDegradeReason reason = new DriveChannelDegradeReason();
    private ControllerRef degradingController = new ControllerRef();
    private DriveChannelStatistics statsControllerA = new DriveChannelStatistics();
    private DriveChannelStatistics statsControllerB = new DriveChannelStatistics();

    public DriveChannel() {
    }

    public DriveChannel(DriveChannel driveChannel) {
        this.channel = driveChannel.channel;
        this.state = driveChannel.state;
        this.reason = driveChannel.reason;
        this.degradingController = driveChannel.degradingController;
        this.statsControllerA = driveChannel.statsControllerA;
        this.statsControllerB = driveChannel.statsControllerB;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public DriveChannelState getState() {
        return this.state;
    }

    public void setState(DriveChannelState driveChannelState) {
        this.state = driveChannelState;
    }

    public DriveChannelDegradeReason getReason() {
        return this.reason;
    }

    public void setReason(DriveChannelDegradeReason driveChannelDegradeReason) {
        this.reason = driveChannelDegradeReason;
    }

    public ControllerRef getDegradingController() {
        return this.degradingController;
    }

    public void setDegradingController(ControllerRef controllerRef) {
        this.degradingController = controllerRef;
    }

    public DriveChannelStatistics getStatsControllerA() {
        return this.statsControllerA;
    }

    public void setStatsControllerA(DriveChannelStatistics driveChannelStatistics) {
        this.statsControllerA = driveChannelStatistics;
    }

    public DriveChannelStatistics getStatsControllerB() {
        return this.statsControllerB;
    }

    public void setStatsControllerB(DriveChannelStatistics driveChannelStatistics) {
        this.statsControllerB = driveChannelStatistics;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.channel);
        this.state.xdrEncode(xDROutputStream);
        this.reason.xdrEncode(xDROutputStream);
        this.degradingController.xdrEncode(xDROutputStream);
        this.statsControllerA.xdrEncode(xDROutputStream);
        this.statsControllerB.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.state.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reason.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.degradingController.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.statsControllerA.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.statsControllerB.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

