/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DdcTag;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class DdcExtent
implements XDRType,
SYMbolAPIConstants {
    private DdcTag ddcTag = new DdcTag();
    private int chunkNumber;
    private ControllerRef controllerRef = new ControllerRef();

    public DdcExtent() {
    }

    public DdcExtent(DdcExtent ddcExtent) {
        this.ddcTag = ddcExtent.ddcTag;
        this.chunkNumber = ddcExtent.chunkNumber;
        this.controllerRef = ddcExtent.controllerRef;
    }

    public DdcTag getDdcTag() {
        return this.ddcTag;
    }

    public void setDdcTag(DdcTag ddcTag) {
        this.ddcTag = ddcTag;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public void setChunkNumber(int n) {
        this.chunkNumber = n;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.ddcTag.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.chunkNumber);
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.ddcTag.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.chunkNumber = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

