/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ChannelType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class ControllerSfpLocation
implements XDRType,
SYMbolAPIConstants {
    private ChannelType channelType = new ChannelType();
    private int channel;
    private int sfpPort;
    private int controllerSlot;

    public ControllerSfpLocation() {
    }

    public ControllerSfpLocation(ControllerSfpLocation controllerSfpLocation) {
        this.channelType = controllerSfpLocation.channelType;
        this.channel = controllerSfpLocation.channel;
        this.sfpPort = controllerSfpLocation.sfpPort;
        this.controllerSlot = controllerSfpLocation.controllerSlot;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getSfpPort() {
        return this.sfpPort;
    }

    public void setSfpPort(int n) {
        this.sfpPort = n;
    }

    public int getControllerSlot() {
        return this.controllerSlot;
    }

    public void setControllerSlot(int n) {
        this.controllerSlot = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.channelType.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.sfpPort);
        xDROutputStream.putInt(this.controllerSlot);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channelType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.sfpPort = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.controllerSlot = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

