/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.BatteryStatus;
import devmgr.versioned.symbol.BatteryTypeData;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.RTRAttributes;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Battery
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef batteryRef = new ComponentRef();
    private BatteryStatus status = new BatteryStatus();
    private Location physicalLocation = new Location();
    private int batteryAge;
    private int batteryLifeRemaining;
    private BatteryTypeData batteryTypeData = new BatteryTypeData();
    private byte[] reserved1;
    private byte[] reserved2;
    private long manufacturerDate;
    private String vendorName;
    private String vendorPN;
    private String vendorSN;
    private String fruType;
    private RTRAttributes rtrAttributes = new RTRAttributes();

    public Battery() {
    }

    public Battery(Battery battery) {
        this.batteryRef = battery.batteryRef;
        this.status = battery.status;
        this.physicalLocation = battery.physicalLocation;
        this.batteryAge = battery.batteryAge;
        this.batteryLifeRemaining = battery.batteryLifeRemaining;
        this.batteryTypeData = battery.batteryTypeData;
        this.reserved1 = battery.reserved1;
        this.reserved2 = battery.reserved2;
        this.manufacturerDate = battery.manufacturerDate;
        this.vendorName = battery.vendorName;
        this.vendorPN = battery.vendorPN;
        this.vendorSN = battery.vendorSN;
        this.fruType = battery.fruType;
        this.rtrAttributes = battery.rtrAttributes;
    }

    public ComponentRef getBatteryRef() {
        return this.batteryRef;
    }

    public void setBatteryRef(ComponentRef componentRef) {
        this.batteryRef = componentRef;
    }

    public BatteryStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatteryStatus batteryStatus) {
        this.status = batteryStatus;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public int getBatteryAge() {
        return this.batteryAge;
    }

    public void setBatteryAge(int n) {
        this.batteryAge = n;
    }

    public int getBatteryLifeRemaining() {
        return this.batteryLifeRemaining;
    }

    public void setBatteryLifeRemaining(int n) {
        this.batteryLifeRemaining = n;
    }

    public BatteryTypeData getBatteryTypeData() {
        return this.batteryTypeData;
    }

    public void setBatteryTypeData(BatteryTypeData batteryTypeData) {
        this.batteryTypeData = batteryTypeData;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public String getVendorPN() {
        return this.vendorPN;
    }

    public void setVendorPN(String string) {
        this.vendorPN = string;
    }

    public String getVendorSN() {
        return this.vendorSN;
    }

    public void setVendorSN(String string) {
        this.vendorSN = string;
    }

    public String getFruType() {
        return this.fruType;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public RTRAttributes getRtrAttributes() {
        return this.rtrAttributes;
    }

    public void setRtrAttributes(RTRAttributes rTRAttributes) {
        this.rtrAttributes = rTRAttributes;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.batteryRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.batteryAge);
        xDROutputStream.putInt(this.batteryLifeRemaining);
        this.batteryTypeData.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.vendorName);
        xDROutputStream.putString(this.vendorPN);
        xDROutputStream.putString(this.vendorSN);
        xDROutputStream.putString(this.fruType);
        this.rtrAttributes.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.batteryRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryAge = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryLifeRemaining = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryTypeData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorPN = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorSN = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rtrAttributes.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

