/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class AutoConfigTemplate
implements XDRType,
SYMbolAPIConstants {
    private PhysicalDriveType phyDriveType = new PhysicalDriveType();
    private RAIDLevel raidLevel = new RAIDLevel();
    private int volumeGroupWidth;
    private int volumesPerGroup;
    private int numberHotSpares;
    private int numberUnassignedDrives;
    private int segmentSize;
    private int readAhead;

    public AutoConfigTemplate() {
    }

    public AutoConfigTemplate(AutoConfigTemplate autoConfigTemplate) {
        this.phyDriveType = autoConfigTemplate.phyDriveType;
        this.raidLevel = autoConfigTemplate.raidLevel;
        this.volumeGroupWidth = autoConfigTemplate.volumeGroupWidth;
        this.volumesPerGroup = autoConfigTemplate.volumesPerGroup;
        this.numberHotSpares = autoConfigTemplate.numberHotSpares;
        this.numberUnassignedDrives = autoConfigTemplate.numberUnassignedDrives;
        this.segmentSize = autoConfigTemplate.segmentSize;
        this.readAhead = autoConfigTemplate.readAhead;
    }

    public PhysicalDriveType getPhyDriveType() {
        return this.phyDriveType;
    }

    public void setPhyDriveType(PhysicalDriveType physicalDriveType) {
        this.phyDriveType = physicalDriveType;
    }

    public RAIDLevel getRaidLevel() {
        return this.raidLevel;
    }

    public void setRaidLevel(RAIDLevel rAIDLevel) {
        this.raidLevel = rAIDLevel;
    }

    public int getVolumeGroupWidth() {
        return this.volumeGroupWidth;
    }

    public void setVolumeGroupWidth(int n) {
        this.volumeGroupWidth = n;
    }

    public int getVolumesPerGroup() {
        return this.volumesPerGroup;
    }

    public void setVolumesPerGroup(int n) {
        this.volumesPerGroup = n;
    }

    public int getNumberHotSpares() {
        return this.numberHotSpares;
    }

    public void setNumberHotSpares(int n) {
        this.numberHotSpares = n;
    }

    public int getNumberUnassignedDrives() {
        return this.numberUnassignedDrives;
    }

    public void setNumberUnassignedDrives(int n) {
        this.numberUnassignedDrives = n;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.phyDriveType.xdrEncode(xDROutputStream);
        this.raidLevel.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.volumeGroupWidth);
        xDROutputStream.putInt(this.volumesPerGroup);
        xDROutputStream.putInt(this.numberHotSpares);
        xDROutputStream.putInt(this.numberUnassignedDrives);
        xDROutputStream.putInt(this.segmentSize);
        xDROutputStream.putInt(this.readAhead);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.phyDriveType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.raidLevel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupWidth = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumesPerGroup = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.numberHotSpares = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.numberUnassignedDrives = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.segmentSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.readAhead = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

