/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.VolumeGroupSummary;

public class AutoConfigSummary
implements XDRType,
SYMbolAPIConstants {
    private int totalVolumeGroups;
    private int hotSpareCount;
    private int unassignedCount;
    private VolumeGroupSummary[] volumeGroupSummary;

    public AutoConfigSummary() {
    }

    public AutoConfigSummary(AutoConfigSummary autoConfigSummary) {
        this.totalVolumeGroups = autoConfigSummary.totalVolumeGroups;
        this.hotSpareCount = autoConfigSummary.hotSpareCount;
        this.unassignedCount = autoConfigSummary.unassignedCount;
        this.volumeGroupSummary = autoConfigSummary.volumeGroupSummary;
    }

    public int getTotalVolumeGroups() {
        return this.totalVolumeGroups;
    }

    public void setTotalVolumeGroups(int n) {
        this.totalVolumeGroups = n;
    }

    public int getHotSpareCount() {
        return this.hotSpareCount;
    }

    public void setHotSpareCount(int n) {
        this.hotSpareCount = n;
    }

    public int getUnassignedCount() {
        return this.unassignedCount;
    }

    public void setUnassignedCount(int n) {
        this.unassignedCount = n;
    }

    public VolumeGroupSummary[] getVolumeGroupSummary() {
        return this.volumeGroupSummary;
    }

    public void setVolumeGroupSummary(VolumeGroupSummary[] volumeGroupSummaryArray) {
        this.volumeGroupSummary = volumeGroupSummaryArray;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.totalVolumeGroups);
        xDROutputStream.putInt(this.hotSpareCount);
        xDROutputStream.putInt(this.unassignedCount);
        int n2 = this.volumeGroupSummary == null ? 0 : this.volumeGroupSummary.length;
        xDROutputStream.putInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.volumeGroupSummary[n3].xdrEncode(xDROutputStream);
            ++n3;
        }
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.totalVolumeGroups = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.hotSpareCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.unassignedCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            int n2 = xDRInputStream.getInt();
            this.volumeGroupSummary = new VolumeGroupSummary[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.volumeGroupSummary[n3] = new VolumeGroupSummary();
                this.volumeGroupSummary[n3].xdrDecode(xDRInputStream);
                ++n3;
            }
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

