/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AlarmStatus;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Alarm
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef alarmRef = new ComponentRef();
    private Location physicalLocation = new Location();
    private AlarmStatus status = new AlarmStatus();
    private boolean isManageable;

    public Alarm() {
    }

    public Alarm(Alarm alarm) {
        this.alarmRef = alarm.alarmRef;
        this.physicalLocation = alarm.physicalLocation;
        this.status = alarm.status;
        this.isManageable = alarm.isManageable;
    }

    public ComponentRef getAlarmRef() {
        return this.alarmRef;
    }

    public void setAlarmRef(ComponentRef componentRef) {
        this.alarmRef = componentRef;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public AlarmStatus getStatus() {
        return this.status;
    }

    public void setStatus(AlarmStatus alarmStatus) {
        this.status = alarmStatus;
    }

    public boolean getIsManageable() {
        return this.isManageable;
    }

    public void setIsManageable(boolean bl) {
        this.isManageable = bl;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.alarmRef.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.isManageable);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.alarmRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.isManageable = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

