/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AccessVolumeRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class AccessVolume
implements XDRType,
SYMbolAPIConstants {
    private boolean enabled;
    private int volumeHandle;
    private long capacity;
    private AccessVolumeRef accessVolumeRef = new AccessVolumeRef();
    private byte[] reserved1;

    public AccessVolume() {
    }

    public AccessVolume(AccessVolume accessVolume) {
        this.enabled = accessVolume.enabled;
        this.volumeHandle = accessVolume.volumeHandle;
        this.capacity = accessVolume.capacity;
        this.accessVolumeRef = accessVolume.accessVolumeRef;
        this.reserved1 = accessVolume.reserved1;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getVolumeHandle() {
        return this.volumeHandle;
    }

    public void setVolumeHandle(int n) {
        this.volumeHandle = n;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long l) {
        this.capacity = l;
    }

    public AccessVolumeRef getAccessVolumeRef() {
        return this.accessVolumeRef;
    }

    public void setAccessVolumeRef(AccessVolumeRef accessVolumeRef) {
        this.accessVolumeRef = accessVolumeRef;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putBoolean(this.enabled);
        xDROutputStream.putInt(this.volumeHandle);
        xDROutputStream.putLong(this.capacity);
        this.accessVolumeRef.xdrEncode(xDROutputStream);
        xDROutputStream.putVariableOpaque(this.reserved1);
        xDROutputStream.setLength(n);
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.enabled = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeHandle = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.capacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.accessVolumeRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }
}

