/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.trace.Trace;
import devmgr.versioned.jrpc.RPCAcceptedReply;
import devmgr.versioned.jrpc.RPCAcceptedStatus;
import devmgr.versioned.jrpc.RPCDebug;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.RPCMsg;
import devmgr.versioned.jrpc.RPCRequestDetails;
import devmgr.versioned.jrpc.TCPChannel;
import devmgr.versioned.jrpc.UDPChannel;
import devmgr.versioned.jrpc.UDPMessageBundle;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDRMessageIOV;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public abstract class RPCServer {
    private int m_Program = 0;
    private int m_Version = 0;
    private int m_TcpTimeout = 0;
    private boolean m_UdpStarted = false;
    private boolean m_TcpStarted = false;
    private Thread m_UdpThread = null;
    private Thread m_TcpListenerThread = null;
    private ThreadGroup m_ThreadGroup = null;
    private boolean m_ThreadGroupStopped = false;
    private boolean m_RunAsDaemon = false;
    private Hashtable m_ReqDetailsTable = new Hashtable();

    public RPCServer(int n, int n2) {
        this.m_Program = n;
        this.m_Version = n2;
        this.m_ThreadGroup = new ThreadGroup(this.toString());
    }

    public void setDaemon(boolean bl) {
        this.m_RunAsDaemon = bl;
    }

    public synchronized int startUDP(int n) throws RPCError, IOException {
        DatagramSocket datagramSocket;
        int n2 = n;
        if (this.m_UdpStarted) {
            throw new RPCError("UDP_SERVER_ACTIVE");
        }
        if (n != 0) {
            datagramSocket = new DatagramSocket(n2);
        } else {
            datagramSocket = new DatagramSocket();
            n2 = datagramSocket.getLocalPort();
        }
        this.m_UdpThread = new Thread(this.m_ThreadGroup, new UDPThread(datagramSocket));
        this.m_UdpThread.setDaemon(this.m_RunAsDaemon);
        this.m_UdpThread.start();
        this.m_UdpStarted = true;
        return n2;
    }

    public synchronized int startTCP(int n) throws RPCError, IOException {
        int n2 = n;
        if (this.m_TcpStarted) {
            throw new RPCError("TCP_SERVER_ACTIVE");
        }
        ServerSocket serverSocket = new ServerSocket(n2);
        n2 = serverSocket.getLocalPort();
        this.m_TcpListenerThread = new Thread(this.m_ThreadGroup, new TCPListenerThread(serverSocket));
        this.m_TcpListenerThread.setDaemon(this.m_RunAsDaemon);
        this.m_TcpListenerThread.start();
        this.m_TcpStarted = true;
        return n2;
    }

    public synchronized void halt() {
        try {
            this.m_ThreadGroup = null;
            this.m_ThreadGroupStopped = true;
        }
        catch (Exception exception) {
            Trace.printStackTrace(79, exception);
        }
    }

    public synchronized void setTcpTimeout(int n) {
        this.m_TcpTimeout = n;
    }

    public synchronized int getTcpTimeout() {
        return this.m_TcpTimeout;
    }

    public RPCRequestDetails getRequestDetails() {
        return (RPCRequestDetails)this.m_ReqDetailsTable.get(Thread.currentThread());
    }

    public void nullHandler() throws RPCError {
    }

    public abstract XDRType processCall(int var1, XDRInputStream var2) throws RPCError;

    protected void exceptionHandler(Exception exception) {
        Trace.println(79, "Exception in RPC server: " + exception.toString());
        Trace.printStackTrace(79, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XDRMessageIOV transact(XDRMessageIOV xDRMessageIOV, boolean bl, InetAddress inetAddress, int n) throws RPCError {
        XDRMessageIOV xDRMessageIOV2 = null;
        XDRInputStream xDRInputStream = new XDRInputStream(xDRMessageIOV);
        XDROutputStream xDROutputStream = null;
        RPCMsg rPCMsg = new RPCMsg();
        RPCMsg rPCMsg2 = new RPCMsg();
        XDRType xDRType = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Thread thread = Thread.currentThread();
        RPCAcceptedReply rPCAcceptedReply = rPCMsg.getBody().getReplyMsg().getAcceptedReply();
        RPCAcceptedStatus rPCAcceptedStatus = rPCAcceptedReply.getBody().getStatus();
        Trace.println(4, "Received call from " + inetAddress);
        if (Trace.isTracing(5)) {
            RPCDebug.dumpIOV(5, xDRMessageIOV);
        }
        rPCMsg2.xdrDecode(xDRInputStream);
        if (rPCMsg2.getBody().getMsgType().getValue() == 0 && rPCMsg2.getBody().getCallMsg().getRpcVersion() == 2) {
            rPCMsg.setXid(rPCMsg2.getXid());
            rPCMsg.getBody().getMsgType().setValue(1);
            rPCAcceptedStatus.setValue(0);
            rPCAcceptedReply.setVerifier(rPCMsg2.getBody().getCallMsg().getVerifier());
            if (rPCMsg2.getBody().getCallMsg().getProgramNo() != this.m_Program) {
                rPCAcceptedStatus.setValue(1);
            } else if (rPCMsg2.getBody().getCallMsg().getVersionNo() != this.m_Version) {
                rPCAcceptedStatus.setValue(2);
                rPCAcceptedReply.getBody().getVersions().setLow(this.m_Version);
                rPCAcceptedReply.getBody().getVersions().setHigh(this.m_Version);
            } else {
                block20: {
                    RPCRequestDetails rPCRequestDetails = new RPCRequestDetails(rPCMsg2, inetAddress, n, bl);
                    this.m_ReqDetailsTable.put(thread, rPCRequestDetails);
                    try {
                        try {
                            bl2 = false;
                            bl3 = false;
                            xDRType = this.processCall(rPCMsg2.getBody().getCallMsg().getProcedure(), xDRInputStream);
                        }
                        catch (RPCError rPCError) {
                            Trace.printStackTrace(79, rPCError);
                            if (rPCError.getMessage().equals("SUPPRESS_REPLY")) {
                                bl3 = true;
                            } else {
                                bl2 = true;
                            }
                            Object var19_18 = null;
                            this.m_ReqDetailsTable.remove(thread);
                            break block20;
                        }
                        Object var19_17 = null;
                        this.m_ReqDetailsTable.remove(thread);
                    }
                    catch (Throwable throwable) {
                        Object var19_19 = null;
                        this.m_ReqDetailsTable.remove(thread);
                        throw throwable;
                    }
                }
                if (!bl3) {
                    if (bl2) {
                        rPCAcceptedStatus.setValue(4);
                    } else if (xDRType == null) {
                        rPCAcceptedStatus.setValue(3);
                    } else {
                        rPCAcceptedStatus.setValue(0);
                    }
                }
            }
            if (!bl3) {
                xDROutputStream = new XDROutputStream();
                rPCMsg.xdrEncode(xDROutputStream);
                if (xDRType != null) {
                    xDRType.xdrEncode(xDROutputStream);
                }
                xDRMessageIOV2 = xDROutputStream.getMessage();
                Trace.println(4, "Sending reply to " + inetAddress);
                if (Trace.isTracing(6)) {
                    RPCDebug.dumpIOV(6, xDRMessageIOV2);
                }
            }
        }
        return xDRMessageIOV2;
    }

    public boolean allowConnection(InetAddress inetAddress) {
        return true;
    }

    private synchronized void startTcpHandler(Socket socket) throws IOException {
        if (!this.allowConnection(socket.getInetAddress())) {
            socket.close();
        } else {
            Thread thread = new Thread(this.m_ThreadGroup, new TCPConnectionThread(socket));
            thread.setDaemon(this.m_RunAsDaemon);
            thread.start();
        }
    }

    class UDPThread
    implements Runnable {
        private UDPChannel m_Channel = null;
        private int m_Port;

        UDPThread(DatagramSocket datagramSocket) {
            this.m_Channel = new UDPChannel(datagramSocket);
            this.m_Port = datagramSocket.getLocalPort();
        }

        protected void finalize() throws Throwable {
            if (this.m_Channel != null) {
                this.m_Channel.close();
            }
        }

        public void run() {
            XDRMessageIOV xDRMessageIOV = null;
            XDRMessageIOV xDRMessageIOV2 = null;
            UDPMessageBundle uDPMessageBundle = null;
            UDPMessageBundle uDPMessageBundle2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + this.m_Port + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.printf(4, "Server UDP thread running on port %d", new Integer(this.m_Port));
            while (!RPCServer.this.m_ThreadGroupStopped) {
                try {
                    uDPMessageBundle2 = this.m_Channel.receiveMsg();
                    xDRMessageIOV = uDPMessageBundle2.getMsg();
                    xDRMessageIOV2 = RPCServer.this.transact(xDRMessageIOV, false, uDPMessageBundle2.getAddress(), uDPMessageBundle2.getPort());
                    if (xDRMessageIOV2 == null) continue;
                    uDPMessageBundle = new UDPMessageBundle(xDRMessageIOV2, uDPMessageBundle2.getAddress(), uDPMessageBundle2.getPort());
                    this.m_Channel.sendMsg(uDPMessageBundle);
                    uDPMessageBundle = null;
                }
                catch (Exception exception) {
                    RPCServer.this.exceptionHandler(exception);
                }
            }
        }
    }

    class TCPListenerThread
    implements Runnable {
        private ServerSocket m_Sock;

        TCPListenerThread(ServerSocket serverSocket) {
            this.m_Sock = serverSocket;
        }

        protected void finalize() throws Throwable {
        }

        public void run() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.m_Sock.getLocalPort();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + n + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.printf(4, "Server TCP listener running on port %d", new Integer(n));
            while (!bl && !RPCServer.this.m_ThreadGroupStopped) {
                try {
                    Socket socket = this.m_Sock.accept();
                    RPCServer.this.startTcpHandler(socket);
                }
                catch (IOException iOException) {
                    RPCServer.this.exceptionHandler(iOException);
                    bl = true;
                }
            }
            try {
                this.m_Sock.close();
            }
            catch (IOException iOException) {
                Trace.printStackTrace(79, iOException);
            }
        }
    }

    class TCPConnectionThread
    implements Runnable {
        private TCPChannel m_Channel = null;
        private InetAddress m_RemoteAddress = null;
        private int m_RemotePort;

        TCPConnectionThread(Socket socket) throws IOException {
            this.m_RemoteAddress = socket.getInetAddress();
            this.m_RemotePort = socket.getPort();
            this.m_Channel = new TCPChannel(socket);
            this.m_Channel.setTimeout(RPCServer.this.getTcpTimeout());
        }

        protected void finalize() throws Throwable {
            if (this.m_Channel != null) {
                this.m_Channel.close();
            }
        }

        public void run() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + this.m_RemoteAddress.toString() + ":" + this.m_RemotePort + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.println(4, "Server TCP thread started");
            while (!bl && !RPCServer.this.m_ThreadGroupStopped) {
                try {
                    XDRMessageIOV xDRMessageIOV = this.m_Channel.receiveMsg();
                    XDRMessageIOV xDRMessageIOV2 = RPCServer.this.transact(xDRMessageIOV, true, this.m_RemoteAddress, this.m_RemotePort);
                    if (xDRMessageIOV2 == null) continue;
                    this.m_Channel.sendMsg(xDRMessageIOV2);
                    xDRMessageIOV2 = null;
                }
                catch (Exception exception) {
                    RPCServer.this.exceptionHandler(exception);
                    bl = true;
                }
            }
            Trace.println(4, "Server TCP thread exiting");
            try {
                this.m_Channel.close();
                this.m_Channel = null;
            }
            catch (Exception exception) {
                Trace.printStackTrace(79, exception);
            }
        }
    }
}

