/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.trace.Trace;
import devmgr.versioned.jrpc.RPCBroadcastReplyHandler;
import devmgr.versioned.jrpc.RPCClientGeneric;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.UDPChannel;
import devmgr.versioned.jrpc.UDPMessageBundle;
import devmgr.versioned.jrpc.XDRMessageIOV;
import devmgr.versioned.jrpc.XDRType;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;

public class RPCClientBroadcast
extends RPCClientGeneric {
    private static final int DEFAULT_TIMEOUT = 25;
    private static final long DELAY_BETWEEN_BROADCAST = 1500L;
    private static int m_ThreadCounter = 0;
    private long m_Timeout = 25000L;
    private InetAddress[] m_ServerAddresses;
    private int m_ServerPort;
    private UDPChannel[] m_AllChannels = null;
    private int m_Xid;
    private Vector m_Exceptions = null;

    public RPCClientBroadcast(int n, int n2, int n3) throws RPCError, IOException {
        super(n, n2);
        String string = InetAddress.getLocalHost().getHostName();
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        this.m_Xid = this.getNextXid();
        this.m_ServerPort = n3;
        this.m_AllChannels = new UDPChannel[inetAddressArray.length];
        if (inetAddressArray.length == 1) {
            this.m_AllChannels[0] = new UDPChannel(new DatagramSocket());
        } else {
            int n4 = 0;
            while (n4 < inetAddressArray.length) {
                this.m_AllChannels[n4] = new UDPChannel(new DatagramSocket(0, inetAddressArray[n4]));
                ++n4;
            }
        }
        this.m_ServerAddresses = new InetAddress[1];
        this.m_ServerAddresses[0] = InetAddress.getByName("255.255.255.255");
    }

    protected void finalize() throws Throwable {
        if (this.m_AllChannels != null) {
            int n = 0;
            while (n < this.m_AllChannels.length) {
                if (this.m_AllChannels[n] != null) {
                    this.m_AllChannels[n].close();
                }
                ++n;
            }
        }
    }

    public void setAddress(InetAddress inetAddress) {
        this.m_ServerAddresses = new InetAddress[1];
        this.m_ServerAddresses[0] = inetAddress;
    }

    public void setAddresses(InetAddress[] inetAddressArray) {
        this.m_ServerAddresses = inetAddressArray;
    }

    public void setTimeout(int n) throws IOException {
        this.m_Timeout = n * 1000;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.m_AllChannels.length) {
                this.m_AllChannels[n2].setTimeout(0);
                ++n2;
            }
        }
    }

    public void close() throws IOException {
        int n = 0;
        while (n < this.m_AllChannels.length) {
            try {
                this.m_AllChannels[n].close();
                this.m_AllChannels[n] = null;
            }
            catch (Exception exception) {
                Trace.printStackTrace(79, exception);
            }
            ++n;
        }
        this.m_AllChannels = null;
    }

    public InetAddress getLocalAddress() {
        return this.m_AllChannels[0].getLocalAddress();
    }

    public XDRMessageIOV transact(XDRMessageIOV xDRMessageIOV, int n) throws RPCError, IOException {
        throw new RPCError("INTERNAL_ERROR");
    }

    public synchronized void broadcast(int n, XDRType xDRType, XDRType xDRType2, RPCBroadcastReplyHandler rPCBroadcastReplyHandler) throws RPCError, IOException {
        BroadcastOnSocket[] broadcastOnSocketArray = null;
        Thread[] threadArray = null;
        String string = null;
        this.m_Exceptions = new Vector();
        if (this.m_AllChannels.length == 1) {
            broadcastOnSocketArray = new BroadcastOnSocket[]{new BroadcastOnSocket(this.m_AllChannels[0], n, xDRType, xDRType2, rPCBroadcastReplyHandler)};
            broadcastOnSocketArray[0].run();
            if (!this.m_Exceptions.isEmpty()) {
                if (this.m_Exceptions.firstElement() instanceof IOException) {
                    throw (IOException)this.m_Exceptions.firstElement();
                }
                if (this.m_Exceptions.firstElement() instanceof RPCError) {
                    throw (RPCError)this.m_Exceptions.firstElement();
                }
            }
        } else {
            broadcastOnSocketArray = new BroadcastOnSocket[this.m_AllChannels.length];
            threadArray = new Thread[this.m_AllChannels.length];
            int n2 = 0;
            while (n2 < this.m_AllChannels.length) {
                broadcastOnSocketArray[n2] = new BroadcastOnSocket(this.m_AllChannels[n2], n, xDRType, xDRType2, rPCBroadcastReplyHandler);
                string = this.getClass().getName() + "_" + m_ThreadCounter;
                threadArray[n2] = new Thread((Runnable)broadcastOnSocketArray[n2], string);
                ++m_ThreadCounter;
                threadArray[n2].start();
                if (n2 < this.m_AllChannels.length - 1) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.printStackTrace(79, interruptedException);
                    }
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.m_AllChannels.length) {
                try {
                    threadArray[n3].join();
                }
                catch (InterruptedException interruptedException) {
                    Trace.printStackTrace(79, interruptedException);
                }
                ++n3;
            }
        }
    }

    public InetAddress getDestinationIP() {
        return null;
    }

    class BroadcastOnSocket
    implements Runnable {
        private UDPChannel m_UdpChannel;
        private RPCBroadcastReplyHandler m_Handler;
        private XDRType m_Arg;
        private XDRType m_Result;
        private int m_Proc;

        BroadcastOnSocket(UDPChannel uDPChannel, int n, XDRType xDRType, XDRType xDRType2, RPCBroadcastReplyHandler rPCBroadcastReplyHandler) {
            this.m_UdpChannel = uDPChannel;
            this.m_Handler = rPCBroadcastReplyHandler;
            this.m_Arg = xDRType;
            this.m_Result = xDRType2;
            this.m_Proc = n;
        }

        public void run() {
            boolean bl = false;
            XDRMessageIOV xDRMessageIOV = null;
            UDPMessageBundle uDPMessageBundle = null;
            UDPMessageBundle uDPMessageBundle2 = null;
            try {
                xDRMessageIOV = RPCClientBroadcast.this.buildRequestMsg(this.m_Proc, RPCClientBroadcast.this.m_Xid, this.m_Arg);
            }
            catch (RPCError rPCError) {
                RPCClientBroadcast.this.m_Exceptions.addElement(rPCError);
                return;
            }
            int n = 0;
            while (n < RPCClientBroadcast.this.m_ServerAddresses.length) {
                Trace.printf(4, "Sending RPC broadcast to %o\n", RPCClientBroadcast.this.m_ServerAddresses[n]);
                uDPMessageBundle = new UDPMessageBundle(xDRMessageIOV, RPCClientBroadcast.this.m_ServerAddresses[n], RPCClientBroadcast.this.m_ServerPort);
                try {
                    this.m_UdpChannel.sendMsg(uDPMessageBundle);
                }
                catch (Exception exception) {
                    RPCClientBroadcast.this.m_Exceptions.addElement(exception);
                    return;
                }
                ++n;
            }
            Date date = new Date();
            while (!bl) {
                if (RPCClientBroadcast.this.m_Timeout > 0L) {
                    Date date2 = new Date();
                    long l = date2.getTime() - date.getTime();
                    if (l > RPCClientBroadcast.this.m_Timeout) {
                        bl = true;
                    } else {
                        try {
                            this.m_UdpChannel.setTimeout((int)(RPCClientBroadcast.this.m_Timeout - l) + 1);
                        }
                        catch (IOException iOException) {
                            Trace.printStackTrace(79, iOException);
                        }
                    }
                }
                if (bl) continue;
                try {
                    uDPMessageBundle2 = this.m_UdpChannel.receiveMsg();
                    Trace.printf(4, "Broadcast reply from %o\n", uDPMessageBundle2.getAddress());
                    RPCClientBroadcast.this.processReplyMsg(uDPMessageBundle2.getMsg(), RPCClientBroadcast.this.m_Xid, this.m_Result);
                    this.m_Handler.processReply(uDPMessageBundle2.getAddress(), this.m_Result);
                }
                catch (Exception exception) {
                    Trace.printStackTrace(79, exception);
                }
            }
        }
    }
}

