/*
 * Decompiled with CFR 0.152.
 */
package devmgr.trace;

import devmgr.trace.Trace;
import devmgr.trace.TraceComponent;
import devmgr.trace.TraceConfiguration;
import devmgr.trace.TraceConstants;
import devmgr.trace.TraceMessageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TraceDialog
extends JDialog {
    Trace m_Trace = Trace.getTrace();
    TraceConfiguration m_TraceConfig = null;
    JRadioButton m_RadioButtonOn = null;
    JRadioButton m_RadioButtonOff = null;
    JRadioButton m_RadioButtonConsole = null;
    JRadioButton m_RadioButtonFile = null;
    JScrollPane m_ScrollPane = null;
    JList m_ComponentList = null;
    JTextField m_TextFieldFileName = null;
    JButton m_ButtonBrowse = null;
    JButton m_ButtonOK = null;
    JButton m_ButtonCancel = null;
    TraceComponent[] m_SortedComponents = null;
    boolean m_ComponentsAdjusted = false;
    SymItem m_SymItem;
    SymAction m_SymAction;
    JLabel m_FreeVMMemory = new JLabel();
    JLabel m_TotalSystemMemoryUsed = new JLabel();
    UpdateLabels m_UpdateThread = new UpdateLabels();

    public TraceDialog(Window window) {
        SymWindow symWindow = new SymWindow();
        super.setModal(true);
        this.addWindowListener(symWindow);
        this.m_SymItem = new SymItem();
        this.m_SymAction = new SymAction();
        this.getRootPane().registerKeyboardAction(new EscapeListener(), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.m_TraceConfig = this.m_Trace.getCurrentSettings();
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setVisible(false);
        this.setResizable(true);
        this.setTitle("Trace Facility");
        this.buildUpperPanel();
        this.buildOutputPanel();
        this.buildButtonPanel();
        ((Component)this).setSize(this.getContentPane().getPreferredSize());
        this.setTracingEnabled(this.m_TraceConfig.getGlobalTracing());
        this.m_UpdateThread.start();
    }

    public TraceDialog(Window window, String string, boolean bl) {
        this(window);
        this.setTitle(string);
    }

    public void dispose() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
        this.m_UpdateThread.interrupt();
        this.m_UpdateThread = null;
        super.dispose();
    }

    private void buildUpperPanel() {
        boolean[] blArray = null;
        int n = 0;
        int[] nArray = null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.getContentPane().add("North", jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), "Tracing"));
        jPanel2.setPreferredSize(new Dimension(144, 84));
        jPanel.add(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.m_RadioButtonOn = new JRadioButton("On", this.m_TraceConfig.getGlobalTracing());
        this.m_RadioButtonOn.setBounds(8, 24, 48, 24);
        this.m_RadioButtonOn.addItemListener(this.m_SymItem);
        jPanel2.add(this.m_RadioButtonOn);
        this.m_RadioButtonOff = new JRadioButton("Off", !this.m_TraceConfig.getGlobalTracing());
        this.m_RadioButtonOff.setBounds(8, 48, 48, 24);
        jPanel2.add(this.m_RadioButtonOff);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_RadioButtonOn);
        buttonGroup.add(this.m_RadioButtonOff);
        this.setMemoryLabelContents();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 12, 5, 9);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_FreeVMMemory, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 12, 5, 9);
        jPanel.add((Component)this.m_TotalSystemMemoryUsed, gridBagConstraints);
        this.m_SortedComponents = this.sortComponents(TraceConstants.TRACE_COMPONENTS);
        this.m_ComponentList = new JList<TraceComponent>(this.m_SortedComponents);
        this.m_ComponentList.setFont(new Font("Dialog", 0, 12));
        this.m_ScrollPane = new JScrollPane(this.m_ComponentList);
        this.m_ScrollPane.setPreferredSize(new Dimension(268, 268));
        this.m_ScrollPane.setBorder(new TitledBorder(new EtchedBorder(1), "Components"));
        this.m_ScrollPane.setViewportBorder(new EtchedBorder(1));
        jPanel.add(this.m_ScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 0, 5, 12);
        gridBagLayout.setConstraints(this.m_ScrollPane, gridBagConstraints);
        blArray = this.m_TraceConfig.getComponentTracing();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.m_SortedComponents.length) {
            if (blArray[this.m_SortedComponents[n3].getComponentID()]) {
                nArray[n4++] = n3;
            }
            ++n3;
        }
        this.m_ComponentList.setSelectedIndices(nArray);
    }

    private void buildOutputPanel() {
        String string = "";
        JPanel jPanel = new JPanel(new FlowLayout(0, 12, 0));
        this.getContentPane().add("Center", jPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), "Output"));
        jPanel.add(jPanel2);
        string = this.m_TraceConfig.getTraceFile();
        boolean bl = string != "";
        this.m_RadioButtonConsole = new JRadioButton("Console", !bl);
        jPanel2.add(this.m_RadioButtonConsole);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_RadioButtonConsole, gridBagConstraints);
        this.m_RadioButtonFile = new JRadioButton("File", bl);
        this.m_RadioButtonFile.addItemListener(this.m_SymItem);
        jPanel2.add(this.m_RadioButtonFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_RadioButtonFile, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_RadioButtonConsole);
        buttonGroup.add(this.m_RadioButtonFile);
        this.m_TextFieldFileName = new JTextField();
        this.m_TextFieldFileName.setEnabled(bl);
        this.m_TextFieldFileName.setText(string);
        this.m_TextFieldFileName.addActionListener(this.m_SymAction);
        this.m_TextFieldFileName.setPreferredSize(new Dimension(408, 24));
        jPanel2.add(this.m_TextFieldFileName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_TextFieldFileName, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 20, 20));
        jPanel2.add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.m_ButtonBrowse = new JButton();
        this.m_ButtonBrowse.setText("Browse");
        this.m_ButtonBrowse.setEnabled(bl);
        this.m_ButtonBrowse.addActionListener(this.m_SymAction);
        jPanel3.add(this.m_ButtonBrowse);
    }

    private void setMemoryLabelContents() {
        Runtime runtime = Runtime.getRuntime();
        this.m_FreeVMMemory.setText("VM free memory: " + NumberFormat.getInstance().format(runtime.freeMemory()));
        this.m_TotalSystemMemoryUsed.setText("Total VM memory allocated from OS: " + NumberFormat.getInstance().format(runtime.totalMemory()));
    }

    private void buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 20, 12));
        this.getContentPane().add("South", jPanel);
        this.m_ButtonOK = new JButton();
        this.m_ButtonOK.setText("OK");
        this.m_ButtonOK.addActionListener(this.m_SymAction);
        jPanel.add(this.m_ButtonOK);
        this.m_ButtonCancel = new JButton();
        this.m_ButtonCancel.setText("Cancel");
        this.m_ButtonCancel.addActionListener(this.m_SymAction);
        jPanel.add(this.m_ButtonCancel);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.m_ComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.m_ComponentsAdjusted = true;
    }

    void setTracingEnabled(boolean bl) {
        this.m_ScrollPane.setEnabled(bl);
        this.m_ComponentList.setEnabled(bl);
        this.m_RadioButtonConsole.setEnabled(bl);
        this.m_RadioButtonFile.setEnabled(bl);
        if (bl && this.m_RadioButtonFile.isSelected()) {
            this.m_TextFieldFileName.setEnabled(true);
            this.m_ButtonBrowse.setEnabled(true);
        } else {
            this.m_TextFieldFileName.setEnabled(false);
            this.m_ButtonBrowse.setEnabled(false);
        }
    }

    TraceComponent[] sortComponents(TraceComponent[] traceComponentArray) {
        TraceComponent traceComponent = null;
        TraceComponent[] traceComponentArray2 = (TraceComponent[])traceComponentArray.clone();
        int n = 1;
        while (n < traceComponentArray2.length) {
            int n2 = 0;
            while (n2 < traceComponentArray2.length - 1) {
                if (traceComponentArray2[n2].compareTo(traceComponentArray2[n2 + 1]) > 0) {
                    traceComponent = traceComponentArray2[n2];
                    traceComponentArray2[n2] = traceComponentArray2[n2 + 1];
                    traceComponentArray2[n2 + 1] = traceComponent;
                }
                ++n2;
            }
            ++n;
        }
        return traceComponentArray2;
    }

    void setConfiguration() {
        boolean bl = false;
        int n = 0;
        while (n < this.m_SortedComponents.length) {
            boolean bl2 = this.m_ComponentList.isSelectedIndex(n);
            this.m_TraceConfig.setComponentTracing(this.m_SortedComponents[n].getComponentID(), bl2);
            if (bl2) {
                bl = true;
            }
            ++n;
        }
        if (this.m_TraceConfig.getGlobalTracing()) {
            String string;
            if (!bl) {
                ((Component)new TraceMessageBox((Window)this, "Error", "At least one component must have tracing selected.")).setVisible(true);
                return;
            }
            if (this.m_RadioButtonFile.isSelected()) {
                string = this.m_TextFieldFileName.getText();
                if (string.equals("")) {
                    ((Component)new TraceMessageBox((Window)this, "Error", "Filename is not specified.")).setVisible(true);
                    return;
                }
            } else {
                string = "";
            }
            this.m_TraceConfig.setTraceFile(string);
        }
        try {
            this.m_Trace.setTraceConfiguration(this.m_TraceConfig);
        }
        catch (IOException iOException) {
            ((Component)new TraceMessageBox((Window)this, "Error", "I/O Error occurred: " + iOException.toString())).setVisible(true);
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    static /* synthetic */ void access$100(TraceDialog traceDialog) {
        traceDialog.setMemoryLabelContents();
    }

    class UpdateLabels
    extends Thread {
        UpdateLabels() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ UpdateLabels this$1;
                    {
                        this.this$1 = updateLabels;
                    }

                    public void run() {
                        TraceDialog.access$100(UpdateLabels.access$000(this.this$1));
                    }
                });
            }
        }

        static /* synthetic */ TraceDialog access$000(UpdateLabels updateLabels) {
            return updateLabels.TraceDialog.this;
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = itemEvent.getStateChange() == 1;
            if (itemSelectable == TraceDialog.this.m_RadioButtonOn) {
                TraceDialog.this.m_TraceConfig.setGlobalTracing(bl);
                TraceDialog.this.setTracingEnabled(bl);
            } else if (itemSelectable == TraceDialog.this.m_RadioButtonFile) {
                TraceDialog.this.m_ButtonBrowse.setEnabled(bl);
                TraceDialog.this.m_TextFieldFileName.setEnabled(bl);
            }
        }
    }

    class EscapeListener
    implements ActionListener {
        EscapeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TraceDialog.this.dispatchEvent(new WindowEvent(TraceDialog.this, 201));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = null;
            Object object = actionEvent.getSource();
            if (object == TraceDialog.this.m_ButtonCancel) {
                TraceDialog.this.dispatchEvent(new WindowEvent(TraceDialog.this, 201));
            } else if (object == TraceDialog.this.m_TextFieldFileName) {
                TraceDialog.this.m_TraceConfig.setTraceFile(TraceDialog.this.m_TextFieldFileName.getText());
                TraceDialog.this.m_ButtonOK.requestFocus();
            } else if (object == TraceDialog.this.m_ButtonBrowse) {
                jFileChooser = new JFileChooser();
                int n = jFileChooser.showDialog(TraceDialog.this, "OK");
                if (n == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    TraceDialog.this.m_TextFieldFileName.setText(string);
                    TraceDialog.this.m_ButtonOK.requestFocus();
                }
            } else if (object == TraceDialog.this.m_ButtonOK) {
                TraceDialog.this.setConfiguration();
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == TraceDialog.this) {
                ((Component)TraceDialog.this).setVisible(false);
                TraceDialog.this.dispose();
            }
        }
    }
}

