/*
 * Decompiled with CFR 0.152.
 */
package devmgr.trace;

import devmgr.trace.TraceConfiguration;
import devmgr.trace.TraceConstants;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Trace
implements TraceConstants {
    private static final int BYTES_PER_LINE = 16;
    private static final char BYTE_SEPARATOR = '.';
    private static final long MAX_WAIT_MS = 5000L;
    private static final char[] m_UpperDigitTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] m_LowerDigitTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Trace m_Trace = null;
    private boolean m_GlobalTracing = false;
    private boolean[] m_ComponentTracing = new boolean[TraceConstants.TRACE_COMPONENTS.length];
    private String m_TraceFile = "";
    private PrintWriter m_Output = null;
    private FileOutputStream m_OutFile = null;
    private boolean m_BeginNewLine = true;
    private SimpleDateFormat m_SimpleDateFormat = null;
    private Thread m_TransactionThread;

    private Trace() {
        int n = 0;
        while (n < this.m_ComponentTracing.length) {
            this.m_ComponentTracing[n] = false;
            ++n;
        }
        this.m_TraceFile = "";
        this.m_TransactionThread = null;
        new SimpleDateFormat();
        this.m_SimpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
    }

    public static Trace getTrace() {
        if (m_Trace == null) {
            m_Trace = new Trace();
        }
        return m_Trace;
    }

    public void finalize() {
        try {
            this.closeOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isTracing(int n) {
        Trace trace = Trace.getTrace();
        return trace.isTracingOn(n);
    }

    public static void print(int n, String string) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printToOutput(trace.formatHeader(n) + string);
        }
    }

    public static void println(int n, String string) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printlnToOutput(trace.formatHeader(n) + string);
        }
    }

    public static void println(int n) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printlnToOutput(trace.formatHeader(n));
        }
    }

    public static void printBuffer(int n, String string, byte[] byArray) {
        Trace.printBuffer(n, string, byArray, 0, byArray.length);
    }

    public static void printBuffer(int n, String string, byte[] byArray, int n2, int n3) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printlnToOutput(trace.formatHeader(n) + string);
            trace.printBufferToOutput(byArray, n2, n3);
        }
    }

    public static String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(byArray.length);
        stringBuffer.append(')');
        int n = 0;
        while (n < byArray.length - 1) {
            stringBuffer.append(Trace.toHex(byArray[n], 2));
            stringBuffer.append('.');
            ++n;
        }
        stringBuffer.append(Trace.toHex(byArray[n], 2));
        return stringBuffer.toString();
    }

    public static void printStackTrace(int n, Throwable throwable) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printlnToOutput(trace.formatHeader(n));
            trace.printStackTraceToOutput(throwable);
        }
    }

    public static void startGroup(int n) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.setLock();
        }
    }

    public static void endGroup(int n) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.clearLock();
        }
    }

    public static void printf(int n, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        Trace.vprintf(n, string, objectArray);
    }

    public static void printf(int n, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9};
        Trace.vprintf(n, string, objectArray);
    }

    public static void vprintf(int n, String string, Object[] objectArray) {
        Trace trace = Trace.getTrace();
        if (trace.isTracingOn(n)) {
            trace.printlnToOutput(trace.formatHeader(n) + Trace.FormatString(string, objectArray).toString());
        }
    }

    public TraceConfiguration getCurrentSettings() {
        TraceConfiguration traceConfiguration = new TraceConfiguration(this.m_GlobalTracing, this.m_ComponentTracing, this.m_TraceFile);
        return traceConfiguration;
    }

    public synchronized void setTraceConfiguration(TraceConfiguration traceConfiguration) throws IOException {
        this.waitLock();
        if (traceConfiguration.getGlobalTracing()) {
            if (!this.m_GlobalTracing) {
                this.m_TraceFile = traceConfiguration.getTraceFile();
                this.openFile();
            } else if (!traceConfiguration.getTraceFile().equals(this.m_TraceFile)) {
                this.closeOutput();
                this.m_TraceFile = traceConfiguration.getTraceFile();
                this.openFile();
            }
            this.m_GlobalTracing = true;
        } else if (this.m_GlobalTracing) {
            this.m_GlobalTracing = false;
            this.closeOutput();
        }
        boolean[] blArray = traceConfiguration.getComponentTracing();
        int n = 0;
        while (n < this.m_ComponentTracing.length) {
            this.m_ComponentTracing[n] = blArray[n];
            ++n;
        }
    }

    public void enableComponents(int[] nArray, String string) throws IOException {
        TraceConfiguration traceConfiguration = new TraceConfiguration(this.m_GlobalTracing, this.m_ComponentTracing, this.m_TraceFile);
        traceConfiguration.setGlobalTracing(true);
        if (string != null) {
            traceConfiguration.setTraceFile(string);
        }
        if (nArray.length == 0) {
            int n = 0;
            while (n < this.m_ComponentTracing.length) {
                traceConfiguration.setComponentTracing(n, true);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                traceConfiguration.setComponentTracing(nArray[n], true);
                ++n;
            }
        }
        this.setTraceConfiguration(traceConfiguration);
    }

    public void disableAll() {
        TraceConfiguration traceConfiguration = new TraceConfiguration(this.m_GlobalTracing, this.m_ComponentTracing, this.m_TraceFile);
        traceConfiguration.setGlobalTracing(false);
        int n = 0;
        while (n < this.m_ComponentTracing.length) {
            traceConfiguration.setComponentTracing(n, false);
            ++n;
        }
        try {
            this.setTraceConfiguration(traceConfiguration);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isTracingOn(int n) {
        return this.m_GlobalTracing && this.m_ComponentTracing[n];
    }

    private synchronized void openFile() throws IOException {
        if (this.m_Output != null) {
            this.m_Output.flush();
            this.m_Output = null;
        }
        if (this.m_OutFile != null) {
            this.m_OutFile.close();
            this.m_OutFile = null;
        }
        if (this.m_TraceFile == "") {
            this.m_Output = new PrintWriter(System.out, true);
        } else {
            this.m_OutFile = new FileOutputStream(this.m_TraceFile, true);
            this.m_Output = new PrintWriter(this.m_OutFile, true);
        }
    }

    private synchronized void closeOutput() throws IOException {
        if (this.m_Output != null) {
            this.m_Output.flush();
            this.m_Output = null;
        }
        if (this.m_OutFile != null) {
            this.m_OutFile.close();
            this.m_OutFile = null;
        }
    }

    private synchronized void printlnToOutput(String string) {
        this.waitLock();
        this.m_Output.println(string);
        this.m_BeginNewLine = true;
    }

    private synchronized void printlnToOutput() {
        this.waitLock();
        this.m_Output.println();
        this.m_BeginNewLine = true;
    }

    private synchronized void printToOutput(String string) {
        this.waitLock();
        this.m_Output.print(string);
        this.m_BeginNewLine = false;
    }

    private synchronized void printStackTraceToOutput(Throwable throwable) {
        this.waitLock();
        throwable.printStackTrace(this.m_Output);
        this.m_Output.flush();
        this.m_BeginNewLine = true;
    }

    private synchronized void printBufferToOutput(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = null;
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.setLength(0);
            stringBuffer2.setLength(0);
            string = Trace.toHex(n3, 4);
            int n4 = 0;
            while (n4 < 16 && n3 < n2) {
                stringBuffer.append(Trace.toHex(byArray[n3], 2));
                if (n4 == 7) {
                    stringBuffer.append('-');
                } else {
                    stringBuffer.append(' ');
                }
                if (byArray[n3] < 32 || byArray[n3] > 126) {
                    stringBuffer2.append('.');
                } else {
                    stringBuffer2.append((char)byArray[n3]);
                }
                ++n4;
                ++n3;
            }
            n4 = stringBuffer.length();
            while (n4 < 48) {
                stringBuffer.append(' ');
                ++n4;
            }
            this.printlnToOutput(string + ": " + stringBuffer + " " + stringBuffer2);
        }
        this.m_BeginNewLine = true;
    }

    private static String toHex(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(n);
        while (stringBuffer.length() + string.length() < n2) {
            stringBuffer.append('0');
        }
        int n3 = string.length() > n2 ? string.length() - n2 : 0;
        while (stringBuffer.length() < n2) {
            stringBuffer.append(string.charAt(n3++));
        }
        return stringBuffer.toString();
    }

    private String formatHeader(int n) {
        String string = "";
        if (this.m_BeginNewLine) {
            try {
                string = this.m_SimpleDateFormat.format(new Date());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "UNKNOWN TIMESTAMP: ";
            }
            return string + "(" + Thread.currentThread().getName() + ") " + TraceConstants.TRACE_COMPONENTS[n].getComponentTag() + ": ";
        }
        return "";
    }

    private static StringBuffer FormatString(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        try {
            int n3 = 0;
            block10: while (n3 < n2) {
                char c;
                if ((c = string.charAt(n3++)) != '%') {
                    stringBuffer.append(c);
                    continue;
                }
                c = string.charAt(n3++);
                boolean bl = false;
                if (c == '0' || c == '.') {
                    bl = true;
                    c = string.charAt(n3++);
                }
                int n4 = 0;
                while (Character.isDigit(c)) {
                    n4 *= 10;
                    n4 += Character.digit(c, 10);
                    c = string.charAt(n3++);
                }
                switch (c) {
                    case 'b': 
                    case 'c': 
                    case 'o': 
                    case 's': {
                        String string2 = objectArray[n++].toString();
                        stringBuffer.append(string2);
                        int n5 = string2.length();
                        while (n5 < n4) {
                            stringBuffer.append(' ');
                            ++n5;
                        }
                        continue block10;
                    }
                    case 'X': 
                    case 'x': {
                        long l = ((Number)objectArray[n++]).longValue();
                        String string3 = Trace.LongToHex(l, 0, c == 'X');
                        int n6 = string3.length();
                        while (n6 < n4) {
                            stringBuffer.append(bl ? (char)'0' : ' ');
                            ++n6;
                        }
                        stringBuffer.append(string3);
                        break;
                    }
                    case 'd': {
                        long l = ((Number)objectArray[n++]).longValue();
                        String string3 = Long.toString(l);
                        if (bl && string3.charAt(0) == '-' && n4 > 0) {
                            stringBuffer.append('-');
                            --n4;
                            string3 = string3.substring(1);
                        }
                        int n7 = string3.length();
                        while (n7 < n4) {
                            stringBuffer.append(bl ? (char)'0' : ' ');
                            ++n7;
                        }
                        stringBuffer.append(string3);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        byte[] byArray = (byte[])objectArray[n++];
                        int n8 = 0;
                        while (n8 < byArray.length) {
                            if (n8 > 0) {
                                stringBuffer.append('.');
                            }
                            stringBuffer.append(Trace.LongToHex((long)byArray[n8] & 0xFFL, 2, c == 'R'));
                            ++n8;
                        }
                        continue block10;
                    }
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer;
    }

    /*
     * Unable to fully structure code
     */
    private static String LongToHex(long var0, int var2_1, boolean var3_2) {
        block2: {
            var4_3 = new StringBuffer();
            v0 = var5_4 = var3_2 != false ? Trace.m_UpperDigitTable : Trace.m_LowerDigitTable;
            if (var0 != 0L) ** GOTO lbl10
            var4_3.append('0');
            break block2;
lbl-1000:
            // 1 sources

            {
                var4_3.append(var5_4[(int)(var0 & 15L)]);
                var0 >>>= 4;
lbl10:
                // 2 sources

                ** while (var0 != 0L)
            }
lbl11:
            // 1 sources

            var6_5 = var4_3.length();
            while (var6_5 < var2_1) {
                var4_3.append('0');
                ++var6_5;
            }
            var4_3.reverse();
        }
        return var4_3.toString();
    }

    private synchronized void setLock() {
        this.waitLock();
        this.m_TransactionThread = Thread.currentThread();
    }

    private synchronized void waitLock() {
        if (Thread.currentThread() == this.m_TransactionThread) {
            return;
        }
        try {
            while (this.m_TransactionThread != null) {
                Date date = new Date();
                this.wait(5000L);
                Date date2 = new Date();
                if (date2.getTime() - date.getTime() < 5000L) continue;
                this.m_Output.println("*** Trace lock timer elapsed - lock has been cleared. ***");
                this.m_BeginNewLine = true;
                this.clearLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void clearLock() {
        this.m_TransactionThread = null;
        this.notifyAll();
    }
}

