/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.transport.https;

import com.sun.netstorage.transport.Header;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.text.DecimalFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class NWS_HttpsTransport {
    private static String receiverHost = "localhost";
    private static String receiverUrl;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean debugMode;
    private static char[] myword;
    private static String certName;
    private static String responseSizeTag;
    private boolean fileMode = true;
    private SSLSocketFactory sockFact;
    private SSLContext ctx;
    private KeyManagerFactory kmf;
    private KeyStore ks;

    public NWS_HttpsTransport() throws Exception {
        this.readProps();
        this.loadCerts();
    }

    public void readProps() throws Exception {
    }

    public void loadCerts() throws Exception {
        this.ctx = SSLContext.getInstance("TLS");
        this.ctx.init(null, null, null);
        this.sockFact = this.ctx.getSocketFactory();
    }

    public void sendEvent(String fileName) throws Exception {
        if (debugMode) {
            System.out.println("filename = " + fileName + " receiver url = " + receiverUrl);
        }
        long totalTime = 0L;
        int nfiles = 0;
        long maxSize = 0L;
        File file = new File(fileName);
        if (file.isDirectory()) {
            File[] eventFiles = file.listFiles();
            nfiles = eventFiles.length;
            for (int i = 0; i < eventFiles.length; ++i) {
                totalTime += this.sendFile(eventFiles[i]);
            }
        } else {
            totalTime = this.sendFile(file);
            nfiles = 1;
        }
        if (debugMode) {
            System.out.println("------------------------------------------------");
            System.out.println("Number of events processed = " + nfiles);
            if (totalTime < 1000L) {
                System.out.println("Processing Time = " + totalTime + " ms");
            } else {
                DecimalFormat myFormat = new DecimalFormat("##.00");
                double timeInSec = (double)totalTime / 1000.0;
                System.out.println("Processing Time = " + myFormat.format(timeInSec) + " sec");
            }
        }
    }

    private HttpURLConnection getHttpURLConnection(String urlStr) throws Exception {
        URL url;
        HttpURLConnection httpConn;
        if (debugMode) {
            System.out.println("Connecting to " + receiverUrl);
        }
        if ((httpConn = (HttpURLConnection)(url = new URL(receiverUrl)).openConnection()).getURL().toString().startsWith("https")) {
            ((HttpsURLConnection)httpConn).setSSLSocketFactory(this.sockFact);
            ((HttpsURLConnection)httpConn).setHostnameVerifier(new SimpleHostnameVerifier(proxyHost));
        }
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        return httpConn;
    }

    private long sendFile(File msgFile) throws Exception {
        String line;
        if (debugMode) {
            System.out.println("Message file name = " + msgFile.getPath());
        }
        long start = System.currentTimeMillis();
        long msgSize = msgFile.length();
        HttpURLConnection httpConn = this.getHttpURLConnection(receiverUrl);
        FileInputStream fs = new FileInputStream(msgFile);
        OutputStream os = httpConn.getOutputStream();
        String header = Header.genHeader("StoradeAlarm", msgFile.length());
        if (debugMode) {
            System.out.println("attaching header : " + header);
        }
        os.write(header.getBytes());
        int nbytes = 0;
        byte[] buffer = new byte[1024];
        while ((nbytes = fs.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, nbytes);
        }
        fs.close();
        os.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
        long responseSize = 0L;
        while ((line = rd.readLine()) != null) {
            int indexE;
            int indexS = line.indexOf(responseSizeTag);
            if (indexS < 0 || (indexE = (indexS += responseSizeTag.length()) + line.substring(indexS).indexOf(";")) < 0) continue;
            String sSize = line.substring(indexS, indexE);
            try {
                responseSize = Long.parseLong(sSize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rd.close();
        long end = System.currentTimeMillis();
        if (debugMode) {
            if (end - start < 1000L) {
                System.out.println("Data Size (in bytes) : " + msgFile.length() + " Time to transfer: " + (end - start) + "ms");
            } else {
                DecimalFormat myFormat = new DecimalFormat("##.00");
                double timeInSec = (double)(end - start) / 1000.0;
                System.out.println("Data Size (in bytes) : " + msgFile.length() + " Time to transfer: " + myFormat.format(timeInSec) + " sec");
            }
        }
        if (msgSize != responseSize) {
            System.err.println("WARNING: Original message size of " + msgSize + " does not match server response size of " + responseSize);
        }
        return end - start;
    }

    public static void main(String[] args) {
        String usage = "Event Tester <directory_name|file_name>";
        try {
            receiverUrl = System.getProperty("https.receiver_url");
            proxyHost = System.getProperty("https.proxyHost");
            String strProxyPort = System.getProperty("https.proxyPort");
            String strDebugMode = System.getProperty("debugMode");
            if (args.length != 1 || receiverUrl == null) {
                System.err.println("Usage : Event Tester <directory_name|file_name>");
                System.exit(1);
            }
            if (proxyHost != null && strProxyPort != null) {
                try {
                    proxyPort = Integer.parseInt(strProxyPort);
                }
                catch (Exception e) {
                    System.err.println("Invalid proxy port (" + proxyPort + ") for proxy server " + proxyHost + "; Using port 80");
                    strProxyPort = "80";
                    System.setProperty("https.proxyPort", strProxyPort);
                }
            }
            if (strDebugMode != null && !strDebugMode.equalsIgnoreCase("false")) {
                debugMode = true;
            }
            NWS_HttpsTransport et = new NWS_HttpsTransport();
            et.sendEvent(args[0]);
            System.out.println("OK");
        }
        catch (Exception e) {
            System.out.println("ERROR:");
            e.printStackTrace();
        }
    }

    static {
        debugMode = false;
        myword = "changeit".toCharArray();
        certName = "/trustedcerts";
        responseSizeTag = "storedSize=";
    }

    public class SimpleHostnameVerifier
    implements HostnameVerifier {
        private String hostname;

        public SimpleHostnameVerifier(String hostname) {
            this.hostname = hostname;
        }

        public boolean verify(String hostname, SSLSession session) {
            if (!this.hostname.equals(hostname)) {
                // empty if block
            }
            return true;
        }
    }
}

