/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.transport;

import java.util.Date;

public class Header {
    public static final String StoradeAlarm = "StoradeAlarm";
    public static final String GetRMDeviceTypes = "GetRMDeviceTypes";
    public static final String Activation = "Activation";
    public static final String START_HEADER = "<rm_message_header>";
    public static final String END_HEADER = "</rm_message_header>";
    private static final String ServerVersion = "1.0";
    private String _type;
    private long _size;
    private long _generatedOn;
    private String _version;

    public Header(String text) throws Exception {
        this.parseHeader(text);
    }

    private void parseHeader(String text) throws Exception {
        this._version = ServerVersion;
        this._type = StoradeAlarm;
        this._size = 0L;
        this._generatedOn = System.currentTimeMillis();
    }

    public String getType() {
        return this._type;
    }

    public long getSize() {
        return this._size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Version: " + this._version + "\n");
        buffer.append("Size: " + this._size + "\n");
        buffer.append("Time: " + this._generatedOn + "\n");
        buffer.append("Type : " + this._type + "\n");
        return buffer.toString();
    }

    public static String genHeader(String msgType, long msgSize) {
        StringBuffer header = new StringBuffer();
        header.append("<rm_message_header>\n");
        header.append("<version>1.0</version>\n");
        header.append("<type>" + msgType + "</type>\n");
        header.append("<size>" + msgSize + "</size>\n");
        header.append("<time>" + new Date().getTime() + "</time>\n");
        header.append("</rm_message_header>\n");
        return header.toString();
    }

    public static boolean validateHeader(String header) {
        return true;
    }

    public static void main(String[] args) {
        try {
            String txt = Header.genHeader(StoradeAlarm, 45445L);
            Header h = new Header(txt);
            System.out.println("msg type = " + h.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

