package TO::HBASTORAGE;
use System;
use strict;
use TO::STORAGE;
use base 'TO::STORAGE';
use Agent::HBASTORAGE;


#      'info' => {
#                'ProductID' => 'DSP',
#                'host' => 'sp7',
#                'sw_WWN' => '210000015d226000',
#                'mgmtLevel' => 'C',
#                'host_type' => 'oob',
#                'name' => 'dsp:210000015d226000',
#                'sw_ipAddr' => '192.168.0.10',
#                'class' => 'storage.dsp',
#                'type' => 'dsp',
#                'BoxName' => 'dsp00'


sub leaf { 1 }
sub diskTotal {9}
sub type {'hbastorage'}

sub topoPort {
  my( $node, $portWWN, $hba, $Config, $devs, $dev_no) = @_;

  my $dev     = $devs->[$dev_no];
  my %L = ('B1' => 0, 'A1' => 1, 'B0' => 2, 'A0' => 3);
  if(exists($dev->{ConnectedOn})){
     if(exists($L{$dev->{ConnectedOn}})){
       my $port = $L{$dev->{ConnectedOn}};
	return($port, $port, $port);
     }
  }
  return $dev->{ConnectPort} + 0;
}


# MERGE IN THE SAME NODE IF IT's An UNKNOWN ProductID

sub newFromDEVICEPORT {
  my($class, $to, $dev, $hba) = @_;

  my $renv      = System->get_renv();
  my $host      = $renv->{hostname};
  my $type      =  $class->type();
  my($k, $key);

  $key = $class->knownDevice($dev) ? ($dev->{uniqueName} || $dev->{ENCNodeWWN} || $dev->{NodeWWN}) : "H$hba->{NodeWWN}" ;

  my $k = "$type:$key";
  my $obj = $to->nodeByName($k) || {};

  my $storages  =  $to->[2];

  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = $k;
  $obj->{info}{BoxName} = $dev->{BoxName} || $dev->{NodeWWN};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "ib";
  $obj->{info}{VendorID}= $dev->{Vendor};
  $obj->{info}{Model}   = $dev->{ProductID};
  $obj->{info}{LGroup}  = $dev->{ProductID};
  $obj->{info}{PortWWN} = $dev->{PortWWN};
  $obj->{info}{NodeWWN} = $dev->{NodeWWN};
  $obj->{info}{ipAddr}  = $dev->{IPAddress};
  $obj->{info}{userLabel}  = $dev->{ProductID};
  $obj->{info}{mgmtLevel}  = "D";
  $obj->{info}{uniqueName}  = $dev->{uniqueName} if $dev->{uniqueName} ;

  $obj->{port} = [] if (!exists $obj->{port});

  my($x);

  $dev->{LocalPortWWN}      = $dev->{PortWWN};
  $obj->{diskInfo}{$dev->{PortWWN}}   = $dev;

  $to->addSyn($dev->{PortWWN}, "$k:0");

  bless($obj, "TO::". uc($type));
  $to->addSyn($key, $k);
  $storages->{$k} = $obj;
  return $obj;
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  return ();
}

sub iconLayout {
  my($obj) = @_;
  my($rows, $dd);

  my $rows  =  1;
  my $dd    = "1";

  my $pi = $obj->{portInfo};
  my $ports =  $#$pi+1;

  my $di    = $obj->{diskInfo};
  my ($disks);
  foreach my $d (keys %$di) {
     $disks++;
  }

  my $cat = "a,HBASTORAGE,$ports/   ,$disks/slot,$dd,_,,FFFFCC/int.gif";

  my $label2 = $obj->{info}{LGroup};

  return ($cat, $label2, 1);


}


1;
