package TO::D2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;

sub leaf { 1 }
sub type { 'd2' }
sub portLabel {
  my($class, $port) = @_;
  return "esm-$port";
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}


sub newFromDev {
  my($class, $to, $dev, $arg) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};
  my $k = $dev->{type} . ":" . $dev->{key};
  my $exist = $to->nodeByName($k);

  my $storages  =  $to->[2];
  my $key       = $dev->{key};

  my $obj = $exist || {};
  $obj->{info}{type}    = 'd2';
  $obj->{info}{class}   = 'storage.d2';
  $obj->{info}{name}    = "d2:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "ib";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "StorEdge-D2";
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{NodeWWN} = $dev->{wwn};
  $obj->{port}          = [];
  my $h = $to->nodeByName("host:$host");
  if ($h) {
     my $hp = $h->port();
     my $hpi = $h->portInfo();
     my $cnt = 0;
     foreach my $w ($dev->{wwn}, $dev->{wwn2}) {
        next if (!$w);
      	my ($hba_i);
	    my $found = -1;
	    for ($hba_i=0; $hba_i <= $#$hpi; $hba_i++) {
	       if ($hpi->[$hba_i]{path} eq $w) {
              $found = $hba_i;
              last;
	       }
	    }
        my $hpc		= ($found >= 0) ? $found : $#$hpi + 1;

        $hp->[$hpc]  = "d2:$key:$cnt";
        $hpi->[$hpc] = { 
                         PortWWN    => "scsi-$key", 
                    LocalPortWWN    => "scsi-$key", 
                         LGroup     => 'scsi', 
                         DriverName => 'scsi',
                         RegisterName => 'scsi', 
                         path       => $w };
        $obj->{portInfo}[$cnt] = {PortWWN  => $w, LogicalPath => $w, 
                                  portType => 'scsi' };
        $obj->{port}[$cnt]     = "host:$host:$hpc";
        $to->addSyn($w, "d2:$key:$cnt");
        $cnt++;
     }
  }

  my $report = {};
  if ($arg->{report}) {
    $report = $arg->{report};
  } else {
    require Agent::D2;
    Agent::D2->read_device_slot_status($report, $dev);
  }

  $obj->{info}{disk_per_row} = $report->{'slot.0.total'} || $report->{'slot.1.total'};

  my $x;
  foreach my $esm (0,1) { 
    for ($x=0; $x <= 11; $x++) {
        next if (!exists($report->{"slot.$esm.$x.dev"})) ;
        my $dev = $report->{"slot.$esm.$x.dev"};
        my $vendor = $report->{"slot.$esm.$x.vendor"};
        my $model  = $report->{"slot.$esm.$x.model"};
        $obj->{diskInfo}{"esm$esm-$x"} = { 
                   devID => "$esm-$x", 
                   VendorID => $vendor . ":" . $model,
                   LogicalPath => "/dev/rdsk/$dev",
                   RegisterName => "$dev-$esm-$x" 
                        };
    }
  }
      
  
  bless($obj, 'TO::D2');
  $to->addSyn($key,  "d2:$key");
  $storages->{"d2:$key"} = $obj;
  return $obj;
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components($name);
  my $i       = $Comp->value("e");
  my $iIB     = $Comp->value("ib");

  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my $port =  $Comp->value("esm.0",0) . "," .
              $Comp->value("esm.1",0);

  my $portInfo = $Comp->value("esm.0",1) . "," .
                 $Comp->value("esm.1",1);

  my($disk, $diskInfo, $otherInfo, $other, $u, $d);
  my($l1, $l2, $p1, $p2, $m1, $v1, $v2, $v3, $v4);

  foreach my $el (0,1) {
    for ($d=0; $d < ($node->info('disk_per_row')||12) ; $d++) {
      $disk     .= $Comp->value("slot.$el.$d",0) . ",";
      $diskInfo .= $Comp->value("slot.$el.$d",1) . ",";
    }
  }

  $Comp->other([], \$other, \$otherInfo);

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
    
}




sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);

  $cat = "a,D2,2/12,6,0/1,_,,D0D0F0/d2.gif";
  $label2 = "D2";

  $ses = 1;

  return ($cat, $label2, $ses);
}


1;
