package TO::A3500FC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
sub leaf { 1 }
sub type { 'a3500fc' }

use strict;

sub topoPort {
  my( $node, $portWWN, $hba,$Config, $devs, $dev_no) = @_;
  my $path = $hba->{info}{path};
  my $p = $node->find_port( $path);
  return ($p);
}


# called by Discover::HBAApi

sub newFromDev {
  my($class, $to, $dev, $arg) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};
  my $k = $dev->{type} . ":" . $dev->{key};
  my $exist = $to->nodeByName($k);

  my $storages  =  $to->[2];
  my $key       = $dev->{key};

  my $obj = $exist || {};
  $obj->{info}{type}    = 'a3500fc';
  $obj->{info}{class}   = 'storage.a3500fc';
  $obj->{info}{name}    = "a3500fc:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "ib";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "A3500FC";
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{NodeWWN} = $dev->{wwn};
  $obj->{port}          = [];
  $obj->{portInfo}      = [];

  bless($obj, 'TO::A3500FC');
  $to->addSyn($key, "a3500fc:$key");
  $storages->{"a3500fc:$key"} = $obj;
  return $obj;
}



sub statusFunc {
  my($class, $name, $State) = @_;

   my $Comp = $State->components($name);
   my $i = $Comp->value("ib");
   my $enc     = $i->[0];
   my $encInfo = $i->[1];
   my $port =  $Comp->value("controller.a",0) . "," .
               $Comp->value("controller.b",0);

   my $portInfo = $Comp->value("controller.a",1) . "," .
                  $Comp->value("controller.b",1);

   my($other, $otherInfo);

   $Comp->other([], \$other, \$otherInfo);

   my($disk, $diskInfo, $d);

   for ($d=0; $d <= 9; $d++) {
      $disk     .= $Comp->value("disk.$d",0) . ",";
      $diskInfo .= $Comp->value("disk.$d",1) . ",";
   }
   return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}


sub iconLayout {
  my($class) = @_;

  return("a,A35,2,10,,_,,E0F0E0/a3500fc.gif", "A3500FC", 2);
}

sub getLogicalPaths{
  my($self) = @_;
  my @paths;
  my $diskInfo = $self->portInfo();
  foreach my $disk (@{$diskInfo}) {
    push(@paths, split(/\|/, $disk->{LogicalPath}));
  }
  return @paths;
}

1;
