package Provider::Trap;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Trap.pm,v 1.3 2004/10/25 15:34:17 mckenney Exp $

use PDM;
use PDM::ConfigFile;
use Carp;
use Message;
use Util;
use System;
use Util::Http;
use SNMPTrap;

use base 'Provider';
sub revision {'$Revision: 1.3 $'}

sub description {'SNMP Traps'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::Trap');
  return $p;
}

# http://shadow:8080/servlet/InsertService

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info);
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('trap');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{"pro.trap.active"} = $q->{"active"}? "Y":"N";
    $renv->{"pro.trap.version"} = $q->{version};
    for ($x=1; $x <= 5; $x++ ) {
      if (!$q->{"ip$x"}){
         # Make sure this entry doesn't exist
	 delete $renv->{"pro.trap$x.ip"};
         delete $renv->{"pro.trap$x.port"};
         delete $renv->{"pro.trap$x.level"};
      }else{
         # Update this entry
         $renv->{"pro.trap$x.ip"}     = $q->{"ip$x"};
         $renv->{"pro.trap$x.port"}   = $q->{"port$x"} || 162;
         $renv->{"pro.trap$x.level"}  = $q->{"level$x"};
      }
    }

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

    $err = Html->info($L->{err_1});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.trap.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  my(%h);
  my $version = Html->makeSelect("version","1=v1|2=v2c", $renv->{"pro.trap.version"});

  my $scr = Html::Screen->new();
  $scr->add(" $err <form  method=get> <input type=hidden name=GO value=GUI::Providers::display>
      <input type=hidden name=option value=$q->{option}>");

  $scr->table({ title => $L->{label}, labelWidth => "40%" },
    [ 
    [ f => $G->{active},   "<input type=checkbox name=active $active> $info" ],
    [ f => "SNMP Version", $version ],
    ]);
 
  my($ip, $port, $device, $level, $hostname, @array);

  for ($x=1; $x <= 5; $x++ ) {
    $ip     = $renv->{"pro.trap$x.ip"};
    $port   = $renv->{"pro.trap$x.port"} || 162;
    $level  = $renv->{"pro.trap$x.level"};
    my $ls =  Util->makeSelect("level$x", "1=$G->{warning}|2=$G->{error}|3=$G->{down}|0=$G->{notice}", $level);
    my($port_s);
    if ($renv->{solution} eq "se2") {
       $port_s = "<input type=hidden name=port$x value=$port>$port";
    } else {
       $port_s = "<input type=text name=port$x value=\"$port\" size=6>";
    }
    push(@array, [$x, "<input type=text name=ip$x value=\"$ip\" size=20>",$port_s, $ls]);
  }

  $scr->list($q, {},
    [
     [ l => "#"        ],
     [ l => $L->{ip}   ],
     [ l => $L->{port} ],
     [ l => $L->{min}  ],
    ],
    \@array,
    [
     [ l => "ACTION_update", $G->{submit_update} ],
    ]);

  $scr->add("</form>");
  return $scr->out();
}


sub RUN {
  my($pro, $idList) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  if ($renv->{"pro.trap.active"}  ne "Y") {
     Debug->print2("  not active, skipping.");
     return;
  }

  my $edocs     = PDM->getMessagesFromList($idList);
  foreach $ed (@$edocs) {
     next if ($ed->type() eq Message::TYPE_ALERT);
     $event_count++;
     Debug->print2("Trap: " . $ed->className . " " . $ed->description );

     my $ev         = $ed->instances()->[0];
     my $event_type = $ev->value("EventType");
     my $actionable = $ev->value("Actionable");
     my $g_no       = $ev->value("GridNo") ;
     my $target     = $ev->value("Target") ;

     next if ($ev->value("MgmtLevel") eq "DS");

     my $sev        = $ev->value("Severity");
     $sev           = int($sev+0.5);
     my $ed_desc    = $ev->value("Description");
     my $ed_discl   = $ev->value("Disclaimer");
     my($ix) = index($event_type, '.');
     my($etype, $cat);
     if ($ix > 0) {
       $cat   = substr($event_type, 0, $ix);
       $etype = substr($event_type, $ix+1);
     }

     for ($x=1; $x <= 5; $x++ ) {
       my $ip     = $renv->{"pro.trap$x.ip"};
       my $port   = $renv->{"pro.trap$x.port"};
       my $level  = $renv->{"pro.trap$x.level"};
       my $hostname= $renv->{"pro.trap$x.hostname"};
       
       next if (!$ip);
       if ($level <= $sev) { # valid for this trap
            my $rc = SNMPTrap->send($ed_desc.$ed_discl, 
                 { IP      => $ip, 
                   port    => $port || 162,
                   device  => $cat,
                   alertLevel => $sev,
                   grid_no => $g_no,
                   key     => $target,
                 });
            Debug->print2("snmpSend: $SNMPTrap::ERR") if (!$rc);
            
       }
     }
  }
}


  
1;
