# $Id: JavaDiags.pm,v 1.3 2004/10/13 19:39:05 jkremer Exp $
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
package Java::JavaDiags;

use Java::JrexMsg;
use Java::JrexClient;
use System;
use Debug;
use strict;


# List tests from the java framework in XML format.
# Returns a hash with error, tests. Tests is an array of 
# test properties in XML format.
sub list {
  my($type, $key) = @_;
  my $out = { "error" => undef };

  my $catDir = System->get_home() . "/System/Catalog/interface";
  if (! -f "$catDir/$type.properties"){
	 return $out;
  }

  my $client = new Java::JrexClient();

  my $jtests = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DiagnosticHelper",
	"getDiagnosticTestProperties",
	[$type]
  );

  if (!$jtests){
	 $out->{error} = $client->error;
	 return $out;
  }
  $out->{tests} = $jtests;
  return $out;
}

# verify diag.
sub verify {
  my($q) = @_;
  my $devKey = $q->{key};
  my($type, $key) = split(/\:/, $devKey);
  my $test   = $q->{test};

  require System;
  my $catDir = System->get_home() . "/System/Catalog/interface";
  if (! -f "$catDir/$type.properties"){
	  Debug->logLine("Java::JavaDiags::verify no catalog for $type");
	 return 110;
  }

  # Call java framework to see if java tests exits with give test name.
  my $client = new Java::JrexClient();

  my $jtest = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DiagnosticHelper",
	"verifyDiagnosticTest",
	[$type, $test]
  );
  if ($jtest){
	 return 0;
  }
  return 111; # No java test exists.
}

# Run a java diag using the default scheduler.
sub run {
  my($q) = @_;

  my $format = $q->{format} || "xml";
  my $devKey = $q->{key};
  my($type, $key) = split(/\:/, $devKey);
  my $test   = $q->{test};

  my $comp   = $q->{comp};
  my $host   = $q->{host};
  my $node   = $q->{node};
  my $ports  = $q->{ports};
  my $target = $q->{target} || $key;

  my $verifyError = Java::JavaDiags::verify($q);
  if ($verifyError){
	 return $verifyError;
  }

  my $test_command = "jtest"; #System->get_home() . "/Diags/bin/jtest";
##  my $opts = "-D $key $test ";
  my $opts = "$key $test ";

  for my $oval ( keys %{$q} ){
	 if ($oval =~ /^opt_/){
		my $opt = $q->{$oval};
		$opts = $opts . substr($oval, 4) . "=" . $opt . " ";
	 }
  }

  my $registers;
  my $timeout = 30;
  my $concurrent = 1;
  my $email;
  my $passes = 1;

  require Scheduler;
  require Client;
  my ($err,$pid) = Scheduler->run('ST',
											 $host,
											 $test_command,
											 $opts,
											 $registers,
											 $concurrent,
											 0,
											 $email,
											 $passes,
											 {
											  ports    => $ports,
											  target   => $target,
											  dev_type => $type,
											  node     => $node,
											  key      => $key,
											  comp     => $comp,
											 },    # info
											 $timeout);

  if ($err){
	 Debug->logLine("Client::Diag::jrun $test: $err");
    print Client->error("xml", 111, "Java Test $test: $err");
	 return 111;
  }
  else {
	 print Client->http_OK();
	 if ($format eq "xml"){
		print Client->xmlTagOpen("DIAG_RUN");
		print Client->xmlAttrib("status", "OK");
		print Client->xmlAttrib("pid", $pid);
		print Client->xmlTagClose();
		print Client->xmlCDATA("ERROR", $err);
		print Client->xmlEndTag("DIAG_RUN");
	 }
	 else {
		print "OK $pid\n";
	 }
  }
  return 0;

}

1;
