# $Id: JVM.pm,v 1.10 2004/10/13 19:39:05 jkremer Exp $
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
package Java::JVM;

use LWP::UserAgent;
use System;
use strict;

sub new {
  my($class, $arg) = @_;

  my $jenv = {
				  "java.home"               => "/usr/java",
				  "java.jrex.port"          => 7766,
				  "java.jrex.idle_timeout"  => 300,
				  "java.jrex.start_timeout" => 60,
				  "java.jrex.debug"         => 0,
				  "java.jrex.user"          => "peer",
				  "java.jrex.pass"          => "peer",
				  "java.jrex.class"  =>
				  "com.sun.netstorage.fm.storade.agent.jmx.JMXServer"
				 };

  my ($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  for my $prop ( keys %{$jenv} ) {
	 if ( $renv->{$prop} ){
		$jenv->{$prop} = $renv->{$prop};
	 }
	 if ($arg){
		if ( $arg->{$prop} ){
		  $jenv->{$prop} = $arg->{$prop};
		}
	 }
  }

  eval {
	 my $ipcFile = System->get_home() . "/DATA/IPC_Access";
	 if ( -f "$ipcFile"){
		open(O, $ipcFile);
		my $line = <O>;
		chop($line);
		my $index = rindex($line, ":");
		my $user  = substr($line, 0, $index);
		my $pass  = substr($line, $index+1);
		$jenv->{"java.jrex.user"} = $user;
		$jenv->{"java.jrex.pass"} = $pass;
		close(O);
	 }
  };

  bless $jenv, "Java::JVM";
  return $jenv;
}


sub getCredential {
  my($this) = @_;
  return ($this->{"java.jrex.user"}, $this->{"java.jrex.pass"});
}

sub getPort {
  my($this) = @_;
  return $this->{"java.jrex.port"};
}

sub getJavaPath {
  my($this) = @_;
  my $path = $this->{"java.path"};
  if (-x $path){
	 return $path;
  }

  my $jhome = $this->{"java.home"};
  if (-d $jhome){
	 $path = $jhome . "/bin/java";
	 if (-x $path){
		$this->{"java.path"} = $path;
		return $path;
	 }
	 $path = $jhome . "/jre/bin/java";
	 if (-x $path){
		$this->{"java.path"} = $path;
		return $path;
	 }
  }

  $path = $jhome;
  if (-x $path){
	 $this->{"java.path"} = $path;
	 return $path;
  }

  return "/bin/java";
}



sub getClasspath {
  my($this) = @_;
  my $SA_HOME   = $this->getHomeDir();
  my $SA_LIB    = "$SA_HOME/lib";
  my $CLASSPATH = "$SA_LIB";

  opendir(O, $SA_LIB);
  my @L = readdir(O);
  closedir(O);
  foreach my $fname (@L) {
	 if ($fname =~ /.jar$/){
		$CLASSPATH .= ":$SA_LIB/$fname";
	 }
  }
  return $CLASSPATH;
}


sub getHomeDir {
  my($this) = @_;
  my $sahome = $this->{"storade.home"};
  if (!$sahome){
	 my $BASEDIR = "/opt";
	 my $PKG     = "SUNWstade";
	 my $pkgerr  = system("pkginfo -q $PKG");
	 if (!$pkgerr){
		$BASEDIR = `pkgparam $PKG BASEDIR`;
		chomp($BASEDIR);
	 }
	 $sahome = "$BASEDIR/$PKG";
	 $this->{"storade.home"} = $sahome;
  }
  return $sahome;
}


# return 1 if JVM is running 0 if not.
sub isRunning {
  my($this) = @_;
  my $url = "http://localhost:" . $this->getPort() . "/jvm/ping";
  my ($user, $pass) = $this->getCredential();
  my $req = HTTP::Request->new(GET => $url);
  $req->authorization_basic($user, $pass);
  my $ua = new LWP::UserAgent;
  my $res = $ua->request($req);
  if ($res->is_success) {
	 return 1;
  }
  return 0;
}

# stop JVM if it is running
sub stop {
  my($this) = @_;
  my $ua = LWP::UserAgent->new;

  if ($this->isRunning()){
	 my $url = "http://localhost:" . $this->getPort() . "/jvm/die";
	 my ($user, $pass) = $this->getCredential();
	 my $req = HTTP::Request->new(GET => $url);
	 $req->authorization_basic($user, $pass);
	 my $res = $ua->request($req);
  }
}

# Startup Server JVM
# return 0 if started otherwise error number.
sub start {
  my($this) = @_;

  my $JCLASS  = $this->{'java.jrex.class'};
  my $JCMD    = $this->getJavaPath();
  $JCMD .= " -DSUNWstade=" . $this->getHomeDir();
  $JCMD .= " -cp " . $this->getClasspath();
  $JCMD .= " " . $JCLASS;

  if ($this->{'java.jrex.idle_timeout'}){
	 $JCMD .= " -i " . $this->{'java.jrex.idle_timeout'};
  }

  my $LOGFILE =  $this->getHomeDir() . "/log/agent_jvm_log";
  open (LOG, ">$LOGFILE");
  print LOG "JVM started with command: $JCMD\n";
  close (LOG);
  my $rc;
  if ($<){
	  $rc = system("$JCMD >>$LOGFILE </dev/null 2>&1 &");
  }
  else { # run as noaccess if UID is root
	 chown ((getpwnam('noaccess'))[2,3], $LOGFILE);
	 $rc = system("su - noaccess -c \"$JCMD >>$LOGFILE </dev/null 2>&1 &\" >/dev/null 2>&1");
  }
  if ($rc != 0){
	 return $rc;
  }

  my $maxTries = 20;
  my $try = 0;
  for ($try = 0; $try < $maxTries; $try++){
	 sleep(1);
	 if ($this->isRunning()){
		return 0;
	 }
	 sleep(1);
  }

  return -1; #timed out
}

# run the JVM in the forground.
# warning call will hang until JVM exits.
sub run {
   my($this) = @_;
	my $JCLASS  = $this->{"java.jrex.class"};
	my $JCMD    = $this->getJavaPath();
	$JCMD .= " -DSUNWstade=" . $this->getHomeDir();
	$JCMD .= " -cp " . $this->getClasspath();
	$JCMD .= " " . $JCLASS;
	my $rc = system("$JCMD");
}

1;
