package Health::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SAMFS.pm,v 1.4 2004/10/01 20:12:24 bkeslin Exp $


use base 'Health';
use NWS::SAMFS;
use Ilist;
use Message;
use Catalog;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.4 $'}


sub all_logic {
 Debug->print3("Executing Health SAM-QFS");
  my($hm, $report) = @_;
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $comp);
  $DB::single = 1;
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my $wwn      = $rep->{'id.device_key'};
  my($log)     = $report->log();
  my($id)      = $report->id("display");
  CIM->version("1.1");

  return if ( $hm->connectionEvent($wwn, $report, {method => 1} )); # return if cannot_connect

  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  # new SAMFS or audit time.
     my($etype) = $audit eq "YES" ? "samfs.AuditEvent" : "samfs.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);

     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => "application:$wwn"   ],
                  [ TargetName  => $id    ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => "$title SAM-QFS called $id"],
                  [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::SAMFS->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0]],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);


     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     PDM->saveMessage($ed);
  }
  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);
  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame', # frame key 
                       Tag               => $wwn,
                       CreationClassName => 'CIM_PhysicalFrame' ]);


  # Check device state

  foreach my $e (sort keys %$rep) {

    if ($e =~ /samfm.devent.(\d+).state/) {  
      my $no = $1;
      $comp = "samfm.devent.$no";
      my $ostate = $orep->{"$e"};
      my $nstate = $rep->{"$e"};
      if ( $ostate ne $nstate) {
        my $args = {};
        $args->{'display_comp'}  = $rep->{"$comp.name"};
        Grid->setCode("samfs.StateChangeEvent.state");
        $hm->stateChangeEvent($comp, 'devState', $report, $rep, $orep, 'CIM_PhysicalFrame',  "$wwn.$comp", $wwn, $args);
      }
    }

    if ($e =~ /samfm.devent.(\d+).status.bad_media/) {
      my $no = $1;
      $comp = "samfm.devent.$no.status";
      my $ostate = $orep->{"$e"};
      my $nstate = $rep->{"$e"};
      if ( $ostate ne $nstate) {
        my $args = {};
        $args->{'display_comp'}  = $rep->{"samfm.devent.$no.name"};
                $args->{'statusLabel'} = "Bad media state";
        Grid->setCode("samfs.StateChangeEvent.status.bad_media");
        $hm->stateChangeEvent($comp, 'badMedia', $report, $rep, $orep, 'CIM_PhysicalFrame',  "$wwn.$comp", $wwn, $args);
      }
    }

    if ($e =~ /samfm.devent.(\d+).status.attention/) {
      my $no = $1;
      $comp = "samfm.devent.$no.status";
      my $ostate = $orep->{"$e"};
      my $nstate = $rep->{"$e"};
      if ( $ostate ne $nstate) {
        my $args = {};
        $args->{'display_comp'}  = $rep->{"samfm.devent.$no.name"};
                $args->{'statusLabel'} = "Attention state";
        Grid->setCode("samfs.StateChangeEvent.status.attention");
        $hm->stateChangeEvent($comp, 'attention', $report, $rep, $orep, 'CIM_PhysicalFrame',  "$wwn.$comp", $wwn, $args);
      }
    }

    if ($e =~ /samfm.devent.(\d+).status.stor_full/) {
      my $no = $1;
      $comp = "samfm.devent.$no.status";
       my $ostate = $orep->{"$e"};
      my $nstate = $rep->{"$e"};
      if ( $ostate ne $nstate) {
        my $args = {};
        $args->{'display_comp'}  = $rep->{"samfm.devent.$no.name"};
                $args->{'statusLabel'} = "Storage Full state";
        Grid->setCode("samfs.StateChangeEvent.status.stor_full");
        $hm->stateChangeEvent($comp, 'storFull', $report, $rep, $orep, 'CIM_PhysicalFrame',  "$wwn.$comp", $wwn, $args);
      }
    }

    if ($e =~ /samfm.devent.(\d+).status.scan_err/) {
      my $no = $1;
      $comp = "samfm.devent.$no.status";
      my $ostate = $orep->{"$e"};
      my $nstate = $rep->{"$e"};
      if ( $ostate ne $nstate) {
        my $args = {};
        $args->{'display_comp'}  = $rep->{"samfm.devent.$no.name"};
                $args->{'statusLabel'} = "Scan Error state";
        Grid->setCode("samfs.StateChangeEvent.status.scan_err");
        $hm->stateChangeEvent($comp, 'scanErr', $report, $rep, $orep, 'CIM_PhysicalFrame',  "$wwn.$comp", $wwn, $args);
      }
    }
  }
}


sub devState {
  my($hm, $rep, $orep, $comp) = @_;
  my($map) = PDM->getDeviceStateMap("SAMFS.availability");
  my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);
  my($status) = $rep->getState("$comp.state");
  my($ostatus) = $orep->getState("$comp.state");
  my($old, $new, $sev, $act) = $map->transition("state.$ostatus", "state.$status", $orep, $rep);
  return ($ostatus, $status, $old, $new, $sev, $act);
}

 sub badMedia {
  my($hm, $rep, $orep, $comp) = @_;
  my($map) = PDM->getDeviceStateMap("SAMFS.availability");
  my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);
  my($status) = $rep->getState("$comp.bad_media");
  my($ostatus) = $orep->getState("$comp.bad_media");
  my($old, $new, $sev, $act) = $map->transition("bad_media.$ostatus", "bad_media.$status", $orep, $rep);
  return ($ostatus, $status, $old, $new, $sev, $act);
  }

sub attention {
  my($hm, $rep, $orep, $comp) = @_;
  my($map) = PDM->getDeviceStateMap("SAMFS.availability");
  my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);
  my($status) = $rep->getState("$comp.attention");
  my($ostatus) = $orep->getState("$comp.attention");
  my($old, $new, $sev, $act) = $map->transition("attention.$ostatus", "attention.$status", $orep, $rep);
  return ($ostatus, $status, $old, $new, $sev, $act);
  }

sub storFull {
  my($hm, $rep, $orep, $comp) = @_;
  my($map) = PDM->getDeviceStateMap("SAMFS.availability");
  my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);
  my($status) = $rep->getState("$comp.stor_full");
  my($ostatus) = $orep->getState("$comp.stor_full");
  my($old, $new, $sev, $act) = $map->transition("stor_full.$ostatus", "stor_full.$status", $orep, $rep);
  return ($ostatus, $status, $old, $new, $sev, $act);
  }

sub scanErr {
  my($hm, $rep, $orep, $comp) = @_;
  my($map) = PDM->getDeviceStateMap("SAMFS.availability");
  my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);
  my($status) = $rep->getState("$comp.scan_err");
  my($ostatus) = $orep->getState("$comp.scan_err");
  my($old, $new, $sev, $act) = $map->transition("scan_err.$ostatus", "scan_err.$status", $orep, $rep);
  return ($ostatus, $status, $old, $new, $sev, $act);
  }

sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($map) = PDM->getDeviceStateMap("SAMFS.availability");
   my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);

   if ($comp =~ /samfm.devent.(\d+).status/) {
     my($status) = $rep->getState("$comp.ready");
     my($ostatus) = $orep->getState("$comp.ready");
     my($old, $new, $sev, $act) = $map->transition("ready.$ostatus", "ready.$status", $orep, $rep);
     return ($ostatus, $status, $old, $new, $sev, $act);
  } elsif ($comp =~ /samfm.devent.(\d+)/) {
     Debug->print3("Detected samfm.devent.X");
     my($status) = $rep->getState("$comp.state");
     my($ostatus) = $orep->getState("$comp.state");
     my($old, $new, $sev, $act) = $map->transition("state.$ostatus", "state.$status", $orep, $rep);
     return ($ostatus, $status, $old, $new, $sev, $act);
  }
 }

1;

          
