package Discover::SE;

use System;
use strict;
use DiscoveryObject;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "se,se2",
          sysDesc => 1,
          fromIP  => 1,   # can try FromIP even if snmp does not work
          };
}

sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;

  if ($sysDesc =~ /sun storedge solution/i
      ) {
     return $class->discoverFromIP($ip, $args);
  }
  return undef;
}



sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $password = $args->{password};
  my($solution, $wwn, $model, $hostname, $port) = Logic::SE->find_solution($ipno);
  $ipno .= ":$port" if ($port);
  return [] if (!$wwn);
  my $name = $wwn;
  # Need to get a list of port WWN's
  my ($err, $report) = Report->readReport($solution . ":" . $wwn, $ipno, 120);
  $report = $report ? $report->value() : {};
  my $wwn_list = $report->{"info.wwnList"};
  $wwn_list =~ s/\|/,/g;

  my $o = DiscoveryObject->newFromString(
           "storage.$solution|$solution|$ipno|$wwn|$wwn|$wwn_list||$name|$model");
  $o->{wwns} = $wwn_list;

  $o->{ipno} .= ":$port" if ($port && index($o->{ipno},":") < 0);
  $o->{mgmtLevel} = "D";
  Discover->updateTopoDevice($o);
  return [$o];
}

1;
