package DeviceReport::MCDATA;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;

  my $rep = $report->content();
  my $summary = $q->{summary};
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $key0 = $rep->{"id.device_key"};

  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $rep->{"id.device_key"}       },
                  device_label => { order => 2 , value => $rep->{"id.device_userLabel"} },
                  device_ip    => { order => 3 , value => $rep->{"id.device_ipno"}      },
                  product_ID   => { order => 4 , value => $rep->{"id.productID"}        },
		  Revision     => { order => 5,  value => $rep->{"info.version"}        },

                 };
  $S{SAN} = $class->san_info($report);

  $S{FRU}{"enclosure"} = {  name=> $rep->{"id.device_name"},
                            id  => 1,
                        status  => $report->status(),
                          type  => $rep->{"id.device_type"},
                       revision => $rep->{"info.version"},
                         serial => $rep->{"id.device_wwn"},
                         vendor => "MCDATA",
                          model => $rep->{"id.device_userLabel"},
                       keyLabel => "WWN",
                       keyValue => $key0,
                           };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1].$L[2]";

       if (!$summary) {
          if ($L[0] eq "sensor" && $L[3] eq "name") {
            my $key = "$key0.$L[1].$L[2]";
            $S{COMPONENT}{$x} = {  name  => $x ,
                               id  => $x ,
                           status  => $rep->{"$x.status"},
                             type  => $L[1],
                          revision => "",
                            serial => "",
                             model => "",
                          keyLabel => "ID",
                          keyValue => $key,
                           };

          } elsif ($L[0] eq "port" && $L[2] eq "state") {
              $x = "$L[0].$L[1]";
              $S{PORT}{$x} = {  name  => $x,
                                 id  => $x,
                              state  => $rep->{"$x.state"},
                             status  => $rep->{"$x.state.AdmStatus"},
                               type  => $rep->{"$x.type"},
                              serial => $rep->{"$x.stats.Wwn"},
                           keyLabel  => "ID",
                           keyValue  => $rep->{"id.wwn"} . ".$x",
                            };

          } elsif ($L[0] eq "system") {
              $x = "$L[0].$L[1]";
              my $val = $rep->{$el};
              $val =~ s/[\<\>]//g;
              $S{SYSTEM}{$x} = { value => $val };

          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




1;
