package DeviceReport::HOST;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;

  my $rep = $report->content();
  my $summary = $q->{summary};
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $name   = $report->id("name") ;
  my $ip     = Util->name2ip($name);
  my $hostid = $rep->{"location.hostId"};
  my $key0   = $report->id("deviceName") ;

  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $hostid },
                  device_name  => { order => 2 , value => $name },
                  device_ip    => { order => 3 , value => $ip   },
                 };
  $S{SAN} = $class->san_info($report);

  $S{FRU}{"enclosure"} = {  name=> $name,
                            id  => 1,
                        status  => $report->status(),
                          type  => $report->id("category"),
                       revision => "",
                         serial => $hostid,
                          model => "",
                         vendor => "SUN",
                       keyLabel => "HOSTID",
                       keyValue => $hostid,
                           };
  my $lun_cnt;
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1]";

       if (!$summary) {
          if (($L[0] eq "lun" || $L[0] eq "SES") && $L[2] eq "wwn") {
            $L[1] =~ s/_+/_/g;
            my $key = "$key0.$L[1]";
            $lun_cnt++;
            my $status = $rep->{"$x.status"} || $rep->{"$x.statusA"};
            $status .= " / " . $rep->{"$x.statusB"} if ($rep->{"$x.statusB"});
            my $type = $L[1];
            $status =~ s/HBA_PORTSTATE_//;
            $S{LOGICAL}{"$L[0].$L[1]"} = { 
                             name  => $rep->{"$x.product"} . " - " . $rep->{"$x.wwn"},
                               id  => "$L[0].$lun_cnt",
                           status  => $status,
                             type  => $type,
                          revision => "",
                            serial => $L[1],
                             model => "",
                          keyLabel => "WWN",
                          keyValue => $rep->{"$x.wwn"},
                           };

          } elsif (($L[0] eq "hba") && ($L[1] ne "count")) {
              $x = "$L[0].$L[1]";
              $S{FRU}{$x} = {  name  => $rep->{"$x.PortWWN"},
                                 id  =>  $x,
                              state  => $rep->{"$x.PortState"},
                            revision => $rep->{"$x.adapter_DriverVersion"} . "/" . 
                                        $rep->{"$x.adapter_FirmwareVersion"},
                             status  => "",
                               type  => $rep->{"$x.adapter_DriverName"},
                           keyLabel  => "DevicePath",
                           keyValue  => $rep->{"$x.path"},
                            };

          } elsif ($L[0] eq "switch" && $L[3] eq "InterNodeWWN") {
              $x = "$L[0].$L[1].Info";

              my $name =  $rep->{"$x.InterLogicalName"} || $rep->{"$x.InterNodeWWN"};
              my $serial = $rep->{"$x.VendorName"} . " - " . $rep->{"$x.ModelName"};

              $S{COMPONENT}{"$L[0].$L[1]"} = { 
	                         name  => $name,
                                 id  => "$L[0].$L[1]",
                              state  => "",
                            revision => $rep->{"$x.ReleaseCode"},
                              serial => $serial,
                             status  => "",
                               type  => $serial,
                            };

          } elsif ($L[0] eq "storage" && $L[2] eq "NodeWWN") {
              $x = "$L[0].$L[1]";
              my $serial = $rep->{"$x.Vendor"} . " - " . $rep->{"$x.ProductID"};
              my $state = $rep->{"$x.PortState"};
              $state =~ s/HBA_PORTSTATE_//;
              $S{COMPONENT}{$x} = {  name  => 
                $rep->{"$x.NodeWWN"} . " - " . ($rep->{"$x.OSDeviceName"}  || $rep->{"$x.PortWWN"}),
                                 id  =>  $x,
                              state  => $state,
                            revision => $rep->{"$x.Model"},
                              serial => $serial,
                             status  => "",
                               type  => $serial,
                            };

          } elsif ($L[0] eq "ports") {
              $x = "$L[0].$L[1]";
              my($front, $front2, $type) = split(/[\/\@]/, $L[1]);
              $S{FRU}{$x} = {  name  => $L[1],
                                 id  =>  $L[1],
                              state  => $rep->{$x},
                             status  => "",
                               type  => $type,
                           keyLabel  => "DevicePath",
                           keyValue  => $L[1],
                            };


          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };
        
          } elsif ($L[0] eq "freeSpace") {
              $x = "$L[0].$L[1]";
              my $val = $rep->{$el};
              if (index($x,"|") >= 0) {
                 $x =~ s/\|/ \(/;
                 $x .= ")";
              }
              $S{SYSTEM}{$x} = { value => $val };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}



1;
