package DeviceReport::HBASTORAGE;
use strict;

use DeviceReport::COMMON;
use base 'DeviceReport::COMMON';

sub fruList  { "hba,device" }
sub compList { "fcport" }


#--------------------------------------------
#  fruList(): return a list of the sections of 
#  the instrumentation_report that shoud be in
#  the FRU section.
#--------------------------------------------


sub xmlHeader {
  my($class, $rep) = @_;
  my $key  = $rep->{'id.key'};
  my $X = {
      device_key=> {order => 1, value => $key  },
      vendor    => {order => 3, value => $rep->{"fcport.0._Vendor"}  },
      product   => {order => 4, value => $rep->{"fcport.0._Product"} },
      HBA_WWN   => {order => 4, value => $rep->{"hba.NodeWWN"}       },
      HBA_Path  => {order => 4, value => $rep->{"hba.path"}          },
      };
  if ($rep->{"fcport.0.IPAddress"}) {
     $X->{IP_Address} = {order => 5, value => $rep->{"fcport.0.IPAddress"} } ;
  }
  return $X;
}



1;
