package DeviceReport::COMMON;
use System;
use strict;
use DeviceReport;
use COMMON;
use base 'DeviceReport';

sub xmlFruList {
  my($class, $report, $q) = @_;

  my $filter = $q->{filter};
  my $rep = $report->content();
  my $FRU = COMMON->fruMap($rep);
  my $fru_list  = $class->fruList();
  my $comp_list = $class->compList();
  my(%S);

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if ($filter && $k !~ /^$filter/);
       if (index(",$fru_list,$comp_list,", ",$L[0],") >= 0 && $L[2] eq "_DeviceID") {

              my $code = index(",$fru_list," , ",$L[0],") >= 0 ? "FRU" : "COMPONENT";

	      my $fruKey = $rep->{"$L[0].$L[1]._Realized"};
              my $F      = $FRU->{$fruKey};
              $S{$code}{$k}            = { name    => $rep->{"$k._ElementName"},
                                           id    => $k,
                                         avail   => $rep->{"$k._Availability"},
                                         state   => $rep->{"$k._EnabledState"},
                                         status  => $rep->{"$k._Status"},
                                         type    => $rep->{"$k._Caption"},
                                        revision => $F->{fwRev},
                                           model => $F->{model},
                                          vendor => $F->{vendor},
                                          serial => $F->{serial},
                                       };
       }
   }
   my $out = DeviceReport->xml(\%S, "ID,SYSTEM");
   return (\%S, $out);
}


#
# called by new GUI framework
# return standard data structure.
#

sub xmlHeader {
  my($class, $rep) = @_;

  return  {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_ip              => {order => 4, value => $rep->{'id.ipno'}        },
      system_revision        => {order => 5, value => $rep->{"system._Version"}},
      nvsram_revision        => {order => 6, value => $rep->{"system.nvsram"}},
      };
}

sub getFRUPerLogical {
  my($class, $rep, $logicalClass) = @_;
  return $class->getFRUCount($rep, $logicalClass) . " / " .
     $rep->{"$logicalClass.count"};
}

# Get the number of fru's associated with a logical class in a report.
sub getFRUCount {
  my($class, $rep, $logicalClass) = @_;

  my $logicalCount = $rep->{"$logicalClass.count"};
  my $x;
  my $fruCount = 0;
  # The index always starts at 1.
  for ($x = 1; $x <= $logicalCount; $x++){
     if ($rep->{"$logicalClass.$x._Realized"}){
        $fruCount++;
     }
  }
  return $fruCount;
} 

sub hash {
  my($class, $report, $q) = @_;

  my($S, $out) = $class->xmlSummary0($report, $q);
  return $S;
}


sub xmlSummary {
  my($class, $report, $q) = @_;

  return $class->xmlSummary0($report, $q);
}

sub xmlSummary0 {
  my($class, $report, $q) = @_;

  my $rep = $report->content();

  my $summary = $q->{summary}; # summary
  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = $class->xmlHeader($rep);

  my $FRU = COMMON->fruMap($rep);

  my $fru_list  = $class->fruList();
  my $comp_list = $class->compList();

  $S{SAN} = $class->san_info($report);
  
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
        if (index(",$fru_list,$comp_list,", ",$L[0],") >= 0 && $L[2] eq "_DeviceID") {

	      my $fruKey = $rep->{"$L[0].$L[1]._Realized"};
              my $F = $FRU->{$fruKey};
              my $code = index(",$fru_list,", ",$L[0],") >= 0 ? "FRU" : "COMPONENT";

              $S{$code}{$k}            = { name    => $rep->{"$k._ElementName"},
                                           id    => $k,
#                                         state   => $rep->{"$k._EnabledState"},
#                                         status  => $rep->{"$k._Status"},
                                         state   => $class->getState($rep, $k),
                                         status  => $class->getStatus($rep, $k),
                                   availability  => $rep->{"$k._Availability"},
                                         type    => $rep->{"$k._Caption"},
                                        revision => $F->{fwRev},
                                           model => $F->{model},
                                          vendor => $F->{vendor},
                                          serial => $F->{serial},
                                        keyLabel => "serialNo",
                                        keyValue => $rep->{$el},
                                       };
          } elsif ($L[0] eq "fcport" && $L[2] eq "_Caption") {
             if ($rep->{"$k._ElementName"}) {
                $S{PORT}{$k} = {    name => $rep->{"$k._ElementName"},  
                                   id => $k,
                               state  => $class->getState($rep, $k),
                               status => $class->getStatus($rep, $k),
                             revision => $rep->{"$k._Revision"},
                             keyLabel => "WWN",
                             keyValue => $rep->{"$k._WWN"},
                                 type => $rep->{"$k._Caption"},
                               serial => $rep->{"$k._Caption"},
                                 };
             }
          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif (($L[0] eq "pool") && ($L[2] eq "_Caption")) {
              $S{LOGICAL}{$k} =  { name    => $rep->{"$k._Name"}, 
                                    id     => $k,
                                  type     => $rep->{"$k._Caption"},
                                  state    => $rep->{"$k._MountState"},
                                 status    => $class->getStatus($rep, $k),
                                 raidLevel => $rep->{"$k._RaidLevel"},
                                       wwn => $rep->{"$k.WWN"},
                                  capacity => $rep->{"$k.capacity"},
                                     disks => $rep->{"$k.diskSet"},
                                 };

          } elsif (($L[0] eq "vdisk") && ($L[2] eq "_Caption")) {
              $S{LOGICAL}{$k} =  { name    => $rep->{"$k._Name"}, 
                                    id     => $k,
                                  type     => $rep->{"$k._Caption"},
                                  state    => $rep->{"$k._MountState"},
                                 status    => $class->getStatus($rep, $k),
                                 raidLevel => $rep->{"$k._RaidLevel"},
                                       wwn => $rep->{"$k.WWN"},
                                  capacity => $rep->{"$k.capacity"},
                                     disks => $rep->{"$k.diskSet"},
                                 };

          } elsif (index(",volume,lun,", ",$L[0],") >= 0  && $L[2] eq "_Caption") {
              $S{LOGICAL}{$k} =  { name     => $rep->{"$k._Name"}, 
                                    id      => $k,
                                  type      => $rep->{"$k._Caption"},
                                 status     => $class->getStatus($rep, $k),
                                 sourcePool => $rep->{"$k._SourceVdisk"},
                                sourceVdisk => $rep->{"$k._SourceVdisk"},
                                 };
                                           
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">" . Client->xmlEncode($rep->{$el}) . "</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}


# Returns the contents of the _Status field from the report.
# If status is "Other", substitute the _RawStatus field contents.
sub getStatus
{
  my($class, $report, $prefix) = @_;

  my $status = $report->{"$prefix._Status"};
  if ($status eq "Other")
  {
     $status = $report->{"$prefix._RawStatus"};
  }

  return $status;

}

# Returns the contents of the _EnabledState field from the report.
# Translate the numerical value to a String value.
# If status is "Other", substitute the contents of the _OtherEnabledState 
# field.
sub getState
{
  my($class, $report, $prefix) = @_;

  my $state = $report->{"$prefix._EnabledState"};


  if ($state eq '1')
  {
     $state = $report->{"$prefix._OtherEnabledState"};
  }
  else
  {
     if ($state eq '2')
     {
        $state = "Enabled";
     }
     elsif ($state eq '3')
     {
        $state = "Disabled";
     }
     elsif ($state eq '4')
     {
        $state = "Shutting Down";
     }
     elsif ($state eq '5')
     {
        $state = "Not Applicable";
     }
     elsif ($state eq '6')
     {
        $state = "Enabled but Offline";
     }
     elsif ($state eq '7')
     {
        $state = "In Test";
     }
     elsif ($state eq '8')
     {
        $state = "Deferred";
     }
     elsif ($state eq '9')
     {
        $state = "Quiesced";
     }
     elsif ($state eq '10')
     {
        $state = "Starting";
     }
     else
     {
        $state = "Unknown";
     }

  }
  return $state
}


1;
