package DeviceReport::9900;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;
  my $summary = $q->{summary};
  my $rep = $report->content();
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $key0 = $rep->{"id.device_key"};
  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $rep->{"id.device_key"}       },
                  device_label => { order => 2 , value => $rep->{"id.device_userLabel"} },
                  revision     => { order => 3 , value => $rep->{"raid.DKCMainVersion"} },
                  product      => { order => 4 , value => $rep->{"raid.DKCProductName"} },
                  type         => { order => 5 , value => $rep->{"id.device_userLabel"} },
                  serial       => { order => 6 ,  value => $rep->{'raid.SerialNumber'}},
                 };
                
  $S{SAN} = $class->san_info($report);
               
  $S{FRU}{"enclosure"} = { name => "Enclosure",
                            id  => "Enclosure",
                        status  => "OK",
                          type  => "Enclosure",
                       revision => $rep->{"raid.DKCMainVersion"},
                         serial => $rep->{"raid.SerialNumber"},
                          model => $rep->{"id.device_userLabel"},
                       keyLabel => "WWN",
                       keyValue => $key0,
                           };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1]";

       if (!$summary) {

	  #'controller.Battery' => 'noError',
          #'controller.Cache' => 'noError',
          #'controller.CSW' => 'noError',
          #'controller.Environment' => 'moderate',
          #'controller.Fan' => 'noError',
          #'controller.Processor' => 'noError',
          #'controller.PS' => 'noError',
          #'controller.SM' => 'noError',

          if ($L[0] eq "controller"  || $L[0] eq "disk") {

            my $key = "$L[0].$L[1]";
            $S{COMPONENT}{$x} = {  name  => $x ,
                               id  => $x ,
                           status  => $rep->{"$el"},
                             type  => $L[0],
                          revision => "",
                            serial => "",
                             model => "",
                          keyLabel => "ID",
                          keyValue => $key,
                           };

          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}



1;
